<?php
require 'config.php';

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// ADMIN DATEN LADEN
$stmt = $pdo->query("SELECT username FROM admin_users WHERE id=1 LIMIT 1");
$admin = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Admin Profil</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background:#f4f4f4;
}
.box {
    max-width:600px;
    margin:auto;
    margin-top:60px;
    background:#fff;
    padding:30px;
    border-radius:10px;
    box-shadow:0 3px 10px rgba(0,0,0,.15);
}
</style>
</head>
<body>

<div class="box">

    <h3 class="mb-4">👤 Admin Profil</h3>

    <p><b>Benutzername:</b> <?= htmlspecialchars($admin['username']) ?></p>

    <hr>

    <h5 class="mb-3">🔐 Passwort ändern</h5>

    <form method="post" action="update_password.php">
        <div class="mb-3">
            <label class="form-label">Neues Passwort</label>
            <input type="password" name="new_password" required class="form-control">
        </div>

        <div class="mb-3">
            <label class="form-label">Wiederholen</label>
            <input type="password" name="new_password2" required class="form-control">
        </div>

        <button class="btn btn-success">Passwort speichern</button>
        <a href="dashboard.php" class="btn btn-secondary">Zurück</a>
    </form>

</div>

</body>
</html>
