<?php
require 'config.php';

ini_set('display_errors',1);
error_reporting(E_ALL);

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

/* =======================================================
   AUTO-MIGRATION: PDF Index Tabelle (SQLite kompatibel)
   ======================================================= */

try {
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS pdf_index (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            path TEXT NOT NULL,
            title TEXT NOT NULL,
            content TEXT NOT NULL,
            pages INTEGER DEFAULT NULL,
            last_index TEXT NOT NULL
        )
    ");
} catch (Throwable $e) {
    error_log('PDF_INDEX CREATE TABLE ERROR: ' . $e->getMessage());
}

/* =======================================================
   AUTO-MIGRATION FÜR SPALTEN IN search_settings
   ======================================================= */

$columns = $pdo->query("PRAGMA table_info(search_settings)")
               ->fetchAll(PDO::FETCH_COLUMN, 1);

function addColumnIfMissing($pdo, $columns, $column, $definition, $defaultValue = null) {
    if (!in_array($column, $columns)) {
        $pdo->exec("ALTER TABLE search_settings ADD COLUMN $column $definition");

        if ($defaultValue !== null) {
            $pdo->prepare("UPDATE search_settings SET $column = :def WHERE id = 1")
                ->execute([':def' => $defaultValue]);
        }
    }
}

addColumnIfMissing($pdo, $columns, 'excluded_folders',   'TEXT', '["/admin","/config"]');
addColumnIfMissing($pdo, $columns, 'allowed_extensions', 'TEXT', '["html","htm","php","txt","pdf"]');
addColumnIfMissing($pdo, $columns, 'protected_patterns', 'TEXT', 'config.php, *.db, .env, *.sql, *.key');
addColumnIfMissing($pdo, $columns, 'widget_css',         'TEXT', '');
addColumnIfMissing($pdo, $columns, 'search_limit',       'INTEGER', 100);
addColumnIfMissing($pdo, $columns, 'pdf_path',           'TEXT', '');

/* =======================================================
   SICHERER DEFAULT-DATENSATZ FÜR search_settings
   ======================================================= */

$stmt = $pdo->query("SELECT COUNT(*) FROM search_settings WHERE id = 1");
$count = (int)$stmt->fetchColumn();

if ($count === 0) {
    $pdo->exec("
        INSERT INTO search_settings (
            id,
            result_mode,
            search_limit,
            excluded_folders,
            allowed_extensions,
            protected_patterns,
            widget_css,
            pdf_path
        ) VALUES (
            1,
            'inline',
            100,
            '[\"/admin\",\"/config\"]',
            '[\"html\",\"htm\",\"php\",\"txt\",\"pdf\"]',
            'config.php, *.db, .env, *.sql, *.key',
            '',
            ''
        )
    ");
}


/* Jetzt erneut laden – garantiert vorhanden */
$stmt = $pdo->query("SELECT * FROM search_settings WHERE id=1 LIMIT 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

/* =======================================================
   SETTINGS PARSEN
   ======================================================= */

$excludedFolders   = json_decode($settings['excluded_folders'], true);
if (!is_array($excludedFolders)) $excludedFolders = [];

$allowedExtensions = json_decode($settings['allowed_extensions'], true);
if (!is_array($allowedExtensions)) $allowedExtensions = [];

$protectedPatterns = $settings['protected_patterns'];

$root = realpath($_SERVER['DOCUMENT_ROOT']);
if (!$root) { $root = dirname(__DIR__, 2); }

$folders = [];
$iterator = new DirectoryIterator($root);

foreach ($iterator as $fileinfo) {
    if (!$fileinfo->isDot() && $fileinfo->isDir()) {
        $folders[] = '/' . $fileinfo->getFilename();
    }
}

$allExtensions = [
    'html','htm','php','txt','pdf','css','js','md','xml','json','csv'
];
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Suchsystem – Admin Dashboard</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<div class="d-flex justify-content-between mb-3">
    <h2>🔧 Suchsystem – Admin Dashboard</h2>
    <div>
        <a class="btn btn-secondary me-2" href="admin_profile.php">Profil</a>
        <a href="logs.php" class="btn btn-secondary mt-3">📄 Suchprotokoll ansehen</a>

        <a class="btn btn-danger" href="logout.php">Logout</a>
    </div>
</div>

<!-- ================= SETTINGS FORM ================ -->
<form class="card p-4" action="save_settings.php" method="post">

    <!-- Ergebnis-Modus -->
    <div class="mb-4">
        <h5>Ergebnisanzeige</h5>
        <div class="form-check">
            <input class="form-check-input" type="radio" name="result_mode" value="inline"
                <?= $settings['result_mode']=='inline'?'checked':''; ?>>
            <label class="form-check-label">Inline anzeigen</label>
        </div>
        <div class="form-check">
            <input class="form-check-input" type="radio" name="result_mode" value="modal"
                <?= $settings['result_mode']=='modal'?'checked':''; ?>>
            <label class="form-check-label">Modal anzeigen</label>
        </div>
    </div>

    <!-- Limit -->
    <div class="mb-4">
        <h5>Limit der Ergebnisse</h5>
        <input type="number" name="search_limit" class="form-control"
            value="<?= htmlspecialchars($settings['search_limit']) ?>"
            min="1" max="500">
    </div>

    <!-- Ordner ausschließen -->
    <div class="mb-4">
        <h5>Ordner ausschließen</h5>
        <?php foreach ($folders as $f): ?>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="excluded_folders[]"
                    value="<?= $f ?>" <?= in_array($f, $excludedFolders) ? 'checked':''; ?>>
                <label class="form-check-label"><?= $f ?></label>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Dateiendungen -->
    <div class="mb-4">
        <h5>Erlaubte Dateitypen</h5>
        <?php foreach ($allExtensions as $ext): ?>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox"
                    name="allowed_extensions[]" value="<?= $ext ?>"
                    <?= in_array($ext, $allowedExtensions) ? 'checked':''; ?>>
                <label class="form-check-label"><?= $ext ?></label>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Protected Patterns -->
    <div class="mb-4">
        <h5>Sensible Dateien blockieren</h5>
        <textarea name="protected_patterns" class="form-control" rows="3"><?= htmlspecialchars($protectedPatterns) ?></textarea>
    </div>

    <!-- CSS Styling -->
    <div class="mb-4">
        <h5>Suchfeld Styling (CSS)</h5>
        <textarea name="widget_css" id="widgetCss" class="form-control" rows="6"><?= htmlspecialchars($settings['widget_css']) ?></textarea>
    </div>

    <button class="btn btn-primary btn-lg">Einstellungen speichern</button>
</form>

<!-- LIVE PREVIEW -->
<div class="card p-4 my-4">
    <h4>🎨 Live Vorschau</h4>

    <style id="widgetPreviewStyle">
        <?= $settings['widget_css']; ?>
    </style>

    <div class="suche-widget border p-3 mt-2">
        <input type="text" placeholder="Suchbegriff…">
        <button type="button" class="btn btn-sm btn-primary">🔍</button>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const textarea = document.getElementById('widgetCss');
    const previewStyle = document.getElementById('widgetPreviewStyle');

    if (!textarea || !previewStyle) return;

    textarea.addEventListener('input', function() {
        previewStyle.textContent = textarea.value;
    });
});
</script>

</body>
</html>
