<?php
require 'config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = trim($_POST['username']);
    $pass = trim($_POST['password']);

    // Admin-Daten aus DB laden
    $stmt = $pdo->prepare("SELECT username, password FROM admin_users WHERE id=1 LIMIT 1");
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && $row['username'] === $user && password_verify($pass, $row['password'])) {
        $_SESSION['admin'] = $user;
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "❌ Login fehlgeschlagen!";
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Admin Login</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: linear-gradient(135deg,#0f2027,#203a43,#2c5364);
    min-height: 100vh;
    display:flex;
    justify-content:center;
    align-items:center;
    font-family: Arial, sans-serif;
}

.login-box {
    width:100%;
    max-width:420px;
    background:#ffffff;
    border-radius:15px;
    padding:30px;
    box-shadow:0 4px 20px rgba(0,0,0,.25);
}

.login-header {
    text-align:center;
    margin-bottom:20px;
}

.login-header h2 {
    font-weight:700;
    color:#203a43;
}

.btn-login {
    width:100%;
    padding:10px;
    background:#203a43;
    color:#fff;
    border:none;
    border-radius:8px;
    font-size:17px;
}

.btn-login:hover {
    background:#2c5364;
}
</style>
</head>
<body>

<div class="login-box">

    <div class="login-header">
        <h2>🔐 Admin Login</h2>
        <p class="text-muted">Suchsystem Verwaltung</p>
    </div>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="post" autocomplete="off">

        <div class="mb-3">
            <label class="form-label">Benutzername</label>
            <input type="text" name="username" class="form-control" required autofocus>
        </div>

        <div class="mb-3">
            <label class="form-label">Passwort</label>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button class="btn btn-login">Anmelden</button>

    </form>

</div>

</body>
</html>
