<?php
require 'config.php';

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$stmt = $pdo->query("
    SELECT id, query, found, ip, created_at
    FROM search_logs
    ORDER BY created_at DESC
    LIMIT 500
");

$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Suchsystem – Suchprotokoll</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

</head>
<body class="bg-light">

<div class="container py-4">

    <div class="d-flex justify-content-between mb-3">
    <h2>📄 Suchprotokoll</h2>
    
    <div>
        <?php if (isset($_GET['deleted'])): ?>
            <span class="badge bg-success me-2">Protokoll gelöscht</span>
        <?php endif; ?>

        <a class="btn btn-danger me-2"
           href="delete_logs.php"
           onclick="return confirm('Soll das gesamte Suchprotokoll wirklich gelöscht werden?');">
            🗑 Protokoll löschen
        </a>

        <a class="btn btn-primary" href="dashboard.php">⬅ Zurück</a>
    </div>
</div>


    <div class="card p-3">
        <table class="table table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Suchbegriff</th>
                    <th>Treffer</th>
                    <th>IP</th>
                    <th>Datum</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($logs as $l): ?>
                <tr>
                    <td><?= $l['id'] ?></td>
                    <td><?= htmlspecialchars($l['query']) ?></td>
                    <td><?= $l['found'] ?></td>
                    <td><?= $l['ip'] ?></td>
                    <td><?= $l['created_at'] ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>
</body>
</html>
