<?php

/**
 * Kleiner Autoloader nur für Smalot\PdfParser
 * Basierend auf deinem Pfad:
 * /var/www/vhosts/niederastroth.de/httpdocs/suche/src/Smalot/PdfParser/Parser.php
 */
spl_autoload_register(function ($class) {
    $prefix  = 'Smalot\\PdfParser\\';
    $len     = strlen($prefix);

    // Andere Namespaces ignorieren
    if (strncmp($class, $prefix, $len) !== 0) {
        return;
    }

    // Klassenname relativ zum Namespace
    $relative = substr($class, $len);

    // Basisverzeichnis für die Smalot-Klassen
    $baseDir  = __DIR__ . '/../src/Smalot/PdfParser/';

    // Namespace-Separators in Pfad umwandeln
    $file = $baseDir . str_replace('\\', '/', $relative) . '.php';

    if (file_exists($file)) {
        require_once $file;
    }
});

class PdfHelper
{
    public static function extractText(string $absFile): ?string
    {
        if (!file_exists($absFile)) {
            return null;
        }

        try {
            // Smalot-Parser – wird via Autoloader geladen
            $parser = new \Smalot\PdfParser\Parser();
            $pdf    = $parser->parseFile($absFile);

            // Zuverlässig: über getPages() gehen
            $pages = $pdf->getPages();
            $text  = '';

            if (!empty($pages)) {
                foreach ($pages as $page) {
                    $text .= $page->getText() . "\n";
                }
            }

            $text = trim($text);
            if ($text === '') {
                return null;
            }

            return $text;

        } catch (\Throwable $e) {
            // Wenn irgendwas schiefgeht: kein Text
            return null;
        }
    }
}
