<?php


define('MAIN_DB_PATH', __DIR__ . '/main.db');

// Stellt eine Verbindung zur Haupt-Datenbank her
function get_main_db_connection() {
    try {
        $pdo = new PDO('sqlite:' . MAIN_DB_PATH);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch (PDOException $e) {
        die("Haupt-Datenbankverbindung fehlgeschlagen: " . $e->getMessage());
    }
}

// Stellt eine dynamische Verbindung zur ausgewählten Datenbank her
function get_dynamic_db_connection($db_filename) {
    // KORRIGIERTE REGULÄRE AUSDRUCKSPRÜFUNG
    // Erlaubt jetzt auch Dateinamen mit Punkten, wie z.B. 'kontakte.sqlite'
    if (!preg_match('/^[a-zA-Z0-9_\-.]+\.db$/', $db_filename)) {
        die("Ungültiger Datenbankname.");
    }
    $db_path = __DIR__ . '/' . $db_filename;
    try {
        $pdo = new PDO('sqlite:' . $db_path);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch (PDOException $e) {
        die("Datenbankverbindung fehlgeschlagen: " . $e->getMessage());
    }
}

// Initialisiert die Haupt- und Benutzerdatenbanken
function init_main_db() {
    $pdo = get_main_db_connection();
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS databases (
            id INTEGER PRIMARY KEY,
            name TEXT NOT NULL UNIQUE,
            filename TEXT NOT NULL UNIQUE
        )
    ");
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS users (
            id INTEGER PRIMARY KEY,
            username TEXT NOT NULL UNIQUE,
            password TEXT NOT NULL
        )
    ");
    $stmt = $pdo->query("SELECT COUNT(*) FROM users");
    if ($stmt->fetchColumn() === 0) {
        $hashed_password = password_hash('admin', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt->execute(['admin', $hashed_password]);
        echo "Standard-Admin-Benutzer ('admin' / 'admin') wurde in der Haupt-Datenbank erstellt.<br>";
    }
}

init_main_db();

?>