<?php
session_start();
require 'config.php';

// Parameter abrufen
$db_file = $_GET['db'] ?? '';
$filename = $_GET['file'] ?? '';
$download = isset($_GET['download']) && $_GET['download'] == '1';

// Grundlegende Validierung
if (empty($db_file) || empty($filename)) {
    http_response_code(400);
    die('Ungültige Parameter');
}

// Dateiname validieren (Sicherheit): Erlaube Buchstaben, Zahlen, Leerzeichen, Unterstriche, Bindestriche und Punkte
if (!preg_match('/^[a-zA-Z0-9_.\s-]+$/', $filename)) {
    http_response_code(400);
    die('Ungültiger Dateiname');
}

// Pfad zum Upload-Verzeichnis korrigieren
$upload_dir = __DIR__ . '/uploads/' . pathinfo($db_file, PATHINFO_FILENAME);
$file_path = $upload_dir . '/' . $filename;

// Prüfen ob Datei existiert
if (!file_exists($file_path)) {
    http_response_code(404);
    die('Datei nicht gefunden');
}

// Zusätzliche Sicherheitsprüfung: Prüfen ob Datei wirklich in der Datenbank existiert
try {
    $pdo = get_dynamic_db_connection($db_file);
    // Suche nach dem Dateinamen (der jetzt auch Leerzeichen enthalten kann)
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM data WHERE file_data LIKE ?");
    $stmt->execute(['%"filename":"' . $filename . '"%']);
    $exists = $stmt->fetchColumn() > 0;
    
    if (!$exists) {
        http_response_code(403);
        die('Datei nicht autorisiert');
    }
} catch (PDOException $e) {
    http_response_code(500);
    die('Datenbankfehler');
}

// MIME-Type bestimmen
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime_type = finfo_file($finfo, $file_path);
finfo_close($finfo);

// Fallback für häufige Dateitypen
if (!$mime_type) {
    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    $mime_types = [
        'jpg' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'png' => 'image/png',
        'gif' => 'image/gif',
        'webp' => 'image/webp',
        'pdf' => 'application/pdf',
        'zip' => 'application/zip',
        'doc' => 'application/msword',
        'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'xls' => 'application/vnd.ms-excel',
        'xlsx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'txt' => 'text/plain'
    ];
    $mime_type = $mime_types[$extension] ?? 'application/octet-stream';
}

// Original-Dateiname aus der Datenbank holen
$original_name = $filename;
try {
    $stmt = $pdo->prepare("SELECT file_data FROM data WHERE file_data LIKE ? LIMIT 1");
    $stmt->execute(['%"filename":"' . $filename . '"%']);
    $file_data = $stmt->fetchColumn();
    
    if ($file_data) {
        $data = json_decode($file_data, true);
        if ($data && isset($data['original_name'])) {
            $original_name = $data['original_name'];
        }
    }
} catch (PDOException $e) {
    // Fehler ignorieren, verwende Fallback-Name
}

// Headers setzen
header('Content-Type: ' . $mime_type);
header('Content-Length: ' . filesize($file_path));

if ($download) {
    // Forced Download
    header('Content-Disposition: attachment; filename="' . $original_name . '"');
    header('Cache-Control: no-cache, must-revalidate');
    header('Expires: 0');
} else {
    // Inline anzeigen (für Bilder)
    if (strpos($mime_type, 'image/') === 0) {
        header('Content-Disposition: inline; filename="' . $original_name . '"');
        header('Cache-Control: public, max-age=3600');
    } else {
        // Für Nicht-Bilder trotzdem Download forcieren
        header('Content-Disposition: attachment; filename="' . $original_name . '"');
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires: 0');
    }
}

// Datei streamen
readfile($file_path);
exit;