<?php
session_start();
require 'config.php';

$main_pdo = get_main_db_connection();
$databases = $main_pdo->query("SELECT * FROM databases ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

$db_file = $_GET['db'] ?? '';
$records = [];
$fields = [];
$total_pages = 0;
$search_term = '';
$limit = 20;
$page = 1;
$view_mode = $_GET['view'] ?? 'table'; // Standard: Tabellenansicht

if (!empty($db_file) && preg_match('/^[a-zA-Z0-9_\-]+\.db$/', $db_file)) {
    try {
        $pdo = get_dynamic_db_connection($db_file);
        
        $search_term = $_GET['search'] ?? '';
        $page = $_GET['page'] ?? 1;
        $limit = $_GET['limit'] ?? 20;
        $valid_limits = [10, 20, 40, 50, 100];
        if (!in_array($limit, $valid_limits)) {
            $limit = 20;
        }
        $offset = ($page - 1) * $limit;

        // Step 1: Find matching record IDs
        $where_clause_ids = '';
        $params_ids = [];
        if (!empty($search_term)) {
            $where_clause_ids = 'WHERE value LIKE ?';
            $params_ids[] = '%' . $search_term . '%';
        }

        $count_query = "SELECT COUNT(DISTINCT record_id) FROM data " . $where_clause_ids;
        $stmt_count = $pdo->prepare($count_query);
        $stmt_count->execute($params_ids);
        $total_records = $stmt_count->fetchColumn();
        $total_pages = ceil($total_records / $limit);

        $record_ids_query = "
            SELECT DISTINCT record_id
            FROM data
            " . $where_clause_ids . "
            ORDER BY record_id ASC
            LIMIT $limit OFFSET $offset
        ";
        $stmt_record_ids = $pdo->prepare($record_ids_query);
        $stmt_record_ids->execute($params_ids);
        $found_record_ids = $stmt_record_ids->fetchAll(PDO::FETCH_COLUMN);

        // Step 2: Fetch all data for the found record IDs
        $fields = $pdo->query("SELECT id, field_name FROM fields ORDER BY sort_order ASC, id ASC")->fetchAll(PDO::FETCH_ASSOC);
        $field_id_to_name = array_column($fields, 'field_name', 'id');
        $field_names_in_order = array_column($fields, 'field_name');

        if (!empty($found_record_ids)) {
            $placeholders = implode(',', array_fill(0, count($found_record_ids), '?'));
            $data_query = "
                SELECT record_id, field_id, value, file_data 
                FROM data
                WHERE record_id IN ($placeholders)
            ";
            $stmt_data = $pdo->prepare($data_query);
            $stmt_data->execute($found_record_ids);
            $results_raw = $stmt_data->fetchAll(PDO::FETCH_ASSOC);

            $records_structured = [];
            foreach ($results_raw as $row) {
                $record_id = $row['record_id'];
                if (!isset($records_structured[$record_id])) {
                    $records_structured[$record_id] = [];
                }
                if (isset($field_id_to_name[$row['field_id']])) {
                    // Speichern von Wert und optionalen Datei-Metadaten
                    $records_structured[$record_id][$field_id_to_name[$row['field_id']]] = [
                        'value' => $row['value'],
                        'file_data' => $row['file_data']
                    ];
                }
            }
            
            foreach ($records_structured as $id => $record) {
                $new_record = [];
                foreach ($field_names_in_order as $field_name) {
                    $new_record[$field_name] = $record[$field_name] ?? ['value' => '', 'file_data' => null];
                }
                $records[$id] = $new_record;
            }
        }
    } catch (PDOException $e) {
        $message = "<div class='alert alert-danger'>Fehler beim Laden der Daten: " . $e->getMessage() . "</div>";
    }
}

// Hilfsfunktion für die Darstellung von Dateiinhalten
// Hilfsfunktion für die Darstellung von Dateiinhalten
function renderFieldContent($field_data, $db_file) {
    $value = $field_data['value'];
    $file_data_json = $field_data['file_data'];

    // Prüfen ob Wert ein Datum ist (z. B. YYYY-MM-DD oder YYYY-MM-DD HH:MM:SS)
    if (!empty($value) && preg_match('/^\d{4}-\d{2}-\d{2}( \d{2}:\d{2}:\d{2})?$/', $value)) {
        try {
            $date = new DateTime($value);
            // Nur Datum in deutschem Format (z. B. 13.09.2025)
            return $date->format('d.m.Y');
        } catch (Exception $e) {
            return htmlspecialchars($value);
        }
    }

    if (!empty($file_data_json)) {
        $file_info = json_decode($file_data_json, true);
        if ($file_info && isset($file_info['filename']) && isset($file_info['original_name'])) {
            $file_url = 'file_handler.php?db=' . urlencode($db_file) . '&file=' . urlencode($file_info['filename']);
            
            // Prüfen, ob es ein Bild ist
            if (strpos($file_info['type'], 'image/') === 0) {
                return "<a href=\"{$file_url}\" data-lightbox=\"images\">
                        <img src=\"{$file_url}\" style=\"width: 100px; height: auto;\" alt=\"Bild-Vorschau\">
                        </a>";
            } else {
                // Normale Download-Links für andere Dateien mit Icons
                $icon_class = 'fa-solid fa-file'; // Standard-Icon
                switch ($file_info['type']) {
                    case 'application/pdf':
                        $icon_class = 'fa-solid fa-file-pdf';
                        break;
                    case 'application/zip':
                    case 'application/x-zip-compressed':
                        $icon_class = 'fa-solid fa-file-zipper';
                        break;
                    case 'application/msword':
                    case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
                        $icon_class = 'fa-solid fa-file-word';
                        break;
                    case 'application/vnd.ms-excel':
                    case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
                        $icon_class = 'fa-solid fa-file-excel';
                        break;
                }
                return "<a href=\"{$file_url}\" target=\"_blank\" download title=\"" . htmlspecialchars($file_info['original_name']) . "\">
                        <i class=\"{$icon_class} file-icon\"></i>
                        </a>";
            }
        }
    }

    return htmlspecialchars($value);
}

?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Öffentlicher Datenzugriff</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/simplelightbox/2.14.3/simple-lightbox.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        /* CSS für die Sortiersymbole */
        .table thead th {
            position: relative;
            cursor: pointer;
        }
        .footer-text {
            color: #555;
            font-size: 0.9rem;
        }
        .table thead th::after {
            font-family: 'Courier New', Courier, monospace;
            content: "\00a0\2195";
            font-size: 0.8em;
            color: #ccc;
            position: absolute;
            right: 8px;
            top: 50%;
            transform: translateY(-50%);
        }
        .table thead th.tablesorter-headerAsc::after {
            content: "\00a0\2191";
            color: #fff;
        }
        .table thead th.tablesorter-headerDesc::after {
            content: "\00a0\2193";
            color: #fff;
        }
        .file-icon {
            font-size: 2.5rem !important;
            vertical-align: middle;
        }
		.table td, 
.table th {
    font-size: 1.3rem;
}
        .table td a i.file-icon {
            font-size: 2.5rem !important;
        }
        
        /* Card-Ansicht CSS */
        .card-view {
            display: none;
        }
        .card-view.active {
            display: block;
        }
        .table-view {
            display: block;
        }
        .table-view.active {
            display: block;
        }
        .table-view:not(.active) {
            display: none;
        }
        
        .record-card {
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
        }
        
        .record-card .card-header {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        
        .field-row {
            display: flex;
            border-bottom: 1px solid #f0f0f0;
            padding: 0.5rem 0;
        }
        
        .field-row:last-child {
            border-bottom: none;
        }
        
        .field-label {
            font-weight: bold;
            min-width: 150px;
            color: #495057;
            padding-right: 1rem;
        }
        
        .field-value {
            flex: 1;
        }
        
        .view-toggle-container {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 1rem;
        }
        
        @media (max-width: 768px) {
            .field-row {
                flex-direction: column;
            }
            .field-label {
                min-width: auto;
                padding-right: 0;
                padding-bottom: 0.25rem;
            }
        }
    </style>
	  <!-- Resize-Skript  -->
    <script>
        window.addEventListener("load", fenster);
        window.addEventListener("resize", fenster);
        function fenster() {
          if (parent.document.getElementsByTagName("iframe")[0]) {
            parent.document.getElementsByTagName("iframe")[0].style.height =
              document.getElementsByTagName("html")[0].offsetHeight +'px';
          }
        }
    </script>
</head>
<body>
    <div class="container-fluid mt-5">
        <h2 class="mb-4">PHP Scripte</h2>
       
        <?php if (empty($db_file)): ?>
            <div class="alert alert-info">Bitte wählen Sie eine Datenbank aus, um die Daten einzusehen.</div>
            <div class="list-group">
                <?php foreach ($databases as $db): ?>
                    <a href="index.php?db=<?php echo urlencode($db['filename']); ?>" class="list-group-item list-group-item-action">
                        <?php echo htmlspecialchars($db['name']); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            
            
            
            <div class="row g-3 mb-4">
                <div class="col-md-7">
                    <form action="index.php" method="get">
                        <div class="input-group">
                            <input type="hidden" name="db" value="<?php echo htmlspecialchars($db_file); ?>">
                            <input type="hidden" name="limit" value="<?php echo htmlspecialchars($limit); ?>">
                            <input type="hidden" name="view" value="<?php echo htmlspecialchars($view_mode); ?>">
                            <input type="text" class="form-control" name="search" placeholder="Suche nach Name, Adresse, etc." value="<?php echo htmlspecialchars($search_term); ?>">
                            <button class="btn btn-primary" type="submit">Suchen</button>
                        </div>
                    </form>
                </div>
                <div class="col-md-2">
                    <form action="index.php" method="get" id="limitForm">
                        <input type="hidden" name="db" value="<?php echo htmlspecialchars($db_file); ?>">
                        <input type="hidden" name="search" value="<?php echo htmlspecialchars($search_term); ?>">
                        <input type="hidden" name="view" value="<?php echo htmlspecialchars($view_mode); ?>">
                        <select name="limit" class="form-select" onchange="this.form.submit()">
                            <?php foreach ($valid_limits as $option): ?>
                                <option value="<?php echo $option; ?>" <?php echo ($limit == $option) ? 'selected' : ''; ?>>
                                    <?php echo $option; ?> Einträge
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </form>
                </div>
                <div class="col-md-3">
                    <div class="view-toggle-container">
                        <div class="btn-group" role="group">
                            <a href="?db=<?php echo urlencode($db_file); ?>&view=table<?php echo !empty($search_term) ? '&search=' . urlencode($search_term) : ''; ?>&limit=<?php echo urlencode($limit); ?>&page=<?php echo urlencode($page); ?>" 
                               class="btn <?php echo $view_mode === 'table' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                <i class="fas fa-table"></i> Tabelle
                            </a>
                            <a href="?db=<?php echo urlencode($db_file); ?>&view=cards<?php echo !empty($search_term) ? '&search=' . urlencode($search_term) : ''; ?>&limit=<?php echo urlencode($limit); ?>&page=<?php echo urlencode($page); ?>" 
                               class="btn <?php echo $view_mode === 'cards' ? 'btn-primary' : 'btn-outline-primary'; ?>">
                                <i class="fas fa-th-large"></i> Karten
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if (empty($records)): ?>
                <div class="alert alert-info" role="alert">
                    Keine Datensätze gefunden.
                </div>
            <?php else: ?>
                <div class="table-view <?php echo $view_mode === 'table' ? 'active' : ''; ?>">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="sortable-table" style="width: 100%;">
                            <thead class="table-dark">
                                <tr>
                                    <?php foreach ($field_names_in_order as $field_name): ?>
                                        <th><?php echo htmlspecialchars($field_name); ?></th>
                                    <?php endforeach; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($records as $record): ?>
                                    <tr>
                                        <?php foreach ($field_names_in_order as $field_name): ?>
                                            <td>
                                                <?php
                                                $field_data = $record[$field_name] ?? ['value' => '', 'file_data' => null];
                                                echo renderFieldContent($field_data, $db_file);
                                                ?>
                                            </td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-view <?php echo $view_mode === 'cards' ? 'active' : ''; ?>">
                    <div class="row">
                        <?php foreach ($records as $record_id => $record): ?>
                            <div class="col-lg-6 col-xl-4 mb-4">
                                <div class="card record-card h-100">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Datensatz #<?php echo $record_id; ?></h6>
                                    </div>
                                    <div class="card-body">
                                        <?php foreach ($field_names_in_order as $field_name): ?>
                                            <?php 
                                            $field_data = $record[$field_name] ?? ['value' => '', 'file_data' => null];
                                            $content = renderFieldContent($field_data, $db_file);
                                            if (!empty($field_data['value']) || !empty($field_data['file_data'])): 
                                            ?>
                                                <div class="field-row">
                                                    <div class="field-label"><?php echo htmlspecialchars($field_name); ?>:</div>
                                                    <div class="field-value"><?php echo $content; ?></div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <nav aria-label="Seiten-Navigation">
                    <ul class="pagination justify-content-center">
                        <?php if ($total_records > $limit): ?>
                            <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?db=<?php echo urlencode($db_file); ?>&page=<?php echo $page - 1; ?><?php echo !empty($search_term) ? '&search=' . urlencode($search_term) : ''; ?>&limit=<?php echo urlencode($limit); ?>&view=<?php echo urlencode($view_mode); ?>">Vorherige</a>
                            </li>
                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                                    <a class="page-link" href="?db=<?php echo urlencode($db_file); ?>&page=<?php echo $i; ?><?php echo !empty($search_term) ? '&search=' . urlencode($search_term) : ''; ?>&limit=<?php echo urlencode($limit); ?>&view=<?php echo urlencode($view_mode); ?>"><?php echo $i; ?></a>
                                </li>
                            <?php endfor; ?>
                            <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                                <a class="page-link" href="?db=<?php echo urlencode($db_file); ?>&page=<?php echo $page + 1; ?><?php echo !empty($search_term) ? '&search=' . urlencode($search_term) : ''; ?>&limit=<?php echo urlencode($limit); ?>&view=<?php echo urlencode($view_mode); ?>">Nächste</a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.31.3/js/jquery.tablesorter.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/simplelightbox/2.14.3/simple-lightbox.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialisiert Tablesorter für Ihre Tabelle (nur wenn Tabelle sichtbar ist)
            if ($('.table-view.active').length > 0) {
                $("#sortable-table").tablesorter();
            }
            
            // Funktion zum Initialisieren der Lightbox
            function initializeLightbox() {
                // Zerstöre bestehende Lightbox-Instanz falls vorhanden
                if (window.lightbox) {
                    window.lightbox.destroy();
                }
                
                // Wähle den korrekten Selektor basierend auf der aktiven Ansicht
                let selector = '';
                if ($('.table-view').hasClass('active')) {
                    selector = '.table-view a[data-lightbox]';
                } else if ($('.card-view').hasClass('active')) {
                    selector = '.card-view a[data-lightbox]';
                }
                
                // Initialisiere die Lightbox, wenn ein Selektor vorhanden ist
                if (selector) {
                    window.lightbox = new SimpleLightbox(selector, {
                        nav: true,
                        navText: ['‹', '›'],
                        captions: true,
                        captionsData: 'title',
                        close: true,
                        closeText: '×',
                        showCounter: true,
                        animationSpeed: 250
                    });
                }
            }
            
            // Initialisierung der Lightbox beim Laden der Seite
            initializeLightbox();
        });
    </script>
    
    <footer class="text-center mt-5 py-3">
        <p class="footer-text">© Volker Niederastroth   erstellt mit dem SQLight DB Manager</p>
    </footer>
</body>
</html>