<?php
$adminUser = "admin";
$adminPass = "geheim";
session_start();

// Login prüfen
if (!isset($_SESSION['admin'])) {
    if (isset($_POST['user'], $_POST['pass'])) {
        if ($_POST['user'] === $adminUser && $_POST['pass'] === $adminPass) {
            $_SESSION['admin'] = true;
            header("Location: admin.php");
            exit;
        } else {
            $error = "❌ Falsche Zugangsdaten";
        }
    }
    ?>
    <!DOCTYPE html>
    <html lang="de">
    <head>
        <meta charset="UTF-8">
        <title>Admin Login</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body class="bg-light d-flex align-items-center justify-content-center vh-100">
    <div class="card shadow p-4" style="max-width:400px;width:100%;">
        <h3 class="mb-3 text-center">🔑 Admin Login</h3>
        <?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
        <form method="post">
            <div class="mb-3"><label class="form-label">Benutzer</label><input type="text" name="user" class="form-control" required></div>
            <div class="mb-3"><label class="form-label">Passwort</label><input type="password" name="pass" class="form-control" required></div>
            <button type="submit" class="btn btn-primary w-100">Login</button>
        </form>
    </div></body></html>
    <?php exit;
}

// Pfade & Variablen
$storageFile = __DIR__."/tokens.json";
$protectedDir = __DIR__."/schutz";
$blacklist = ['.htaccess', '.gitignore'];
$tokens = file_exists($storageFile) ? json_decode(file_get_contents($storageFile), true) : [];
$message="";

// Token erstellen (nur beim Absenden)
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create'])){
    $files = $_POST['files'] ?? [];
    $hours = intval($_POST['hours']);
    $maxDownloads = intval($_POST['maxDownloads'] ?? 1);
    if(!empty($files) && $hours>0 && $maxDownloads>0){
        $token = bin2hex(random_bytes(16));
        $expires = time() + ($hours * 3600);
        $downloads = [];
        foreach($files as $f) $downloads[$f] = 0;
        $tokens[$token] = [
            "files" => $files,
            "expires" => $expires,
            "downloads" => $downloads,
            "maxDownloads" => $maxDownloads
        ];
        file_put_contents($storageFile, json_encode($tokens), LOCK_EX);
        $message = "<div class='alert alert-success'>✅ Token erstellt!</div>";
    } else {
        $message = "<div class='alert alert-warning'>⚠️ Bitte mindestens eine Datei und gültige Zeit angeben!</div>";
    }
}

// Token löschen
if(isset($_GET['delete'])){
    unset($tokens[$_GET['delete']]);
    file_put_contents($storageFile,json_encode($tokens));
    $message="<div class='alert alert-info'>🗑️ Token gelöscht</div>";
}

// Token-Link generieren
function tokenLink($tk){
    $dir = dirname($_SERVER['SCRIPT_NAME']);
    return $dir . "/download.php?token=$tk";
}

// Dateien rekursiv auflisten: Root-Dateien zuerst, dann Unterordner
function listFiles($dir, $prefix=""){
    global $blacklist;
    $items = array_diff(scandir($dir), ['.', '..']);
    $files = [];
    $folders = [];
    foreach($items as $item){
        if(in_array($item, $blacklist)) continue;
        $full = "$dir/$item";
        if(is_dir($full)) $folders[$item] = $full;
        else $files[$item] = $full;
    }
    // Root-Dateien zuerst
    foreach($files as $file=>$full){
        $id = uniqid("f_");
        echo "<div class='form-check'><input class='form-check-input' type='checkbox' name='files[]' value='".htmlspecialchars($prefix.$file)."' id='$id'>
        <label class='form-check-label' for='$id'>".htmlspecialchars($prefix.$file)."</label></div>";
    }
    // Unterordner als Accordion
    foreach($folders as $folder=>$full){
        $id = uniqid("folder_");
        echo "<div class='accordion' id='$id'>";
        echo "<div class='accordion-item'>";
        echo "<h2 class='accordion-header'><button class='accordion-button collapsed' type='button' data-bs-toggle='collapse' data-bs-target='#{$id}_collapse' aria-expanded='false'>📁 ".htmlspecialchars($prefix.$folder)."</button></h2>";
        echo "<div id='{$id}_collapse' class='accordion-collapse collapse'><div class='accordion-body'>";
        listFiles($full, $prefix.$folder."/"); // rekursiv
        echo "</div></div></div></div>";
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Token Verwaltung</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
<div class="d-flex justify-content-between align-items-center mb-4">
<h2>🔐 Token-Verwaltung</h2>
<a href="?logout=1" class="btn btn-outline-danger">🚪 Logout</a>
</div>

<?= $message ?>

<!-- Token erstellen -->
<div class="card shadow mb-4"><div class="card-body">
<h4 class="card-title">Neuen Token erstellen</h4>
<form method="post">
<div class="mb-3">
    <label class="form-label">Gültigkeit (Stunden)</label>
    <input type="number" name="hours" value="24" class="form-control" required>
</div>
<div class="mb-3">
    <label class="form-label">Max Downloads pro Datei</label>
    <input type="number" name="maxDownloads" value="5" class="form-control" required>
</div>
<div class="mb-3"><label class="form-label">Dateien auswählen</label><br>
<?php listFiles($protectedDir); ?>
</div>
<button type="submit" name="create" class="btn btn-success">Token erstellen</button>
</form>
</div></div>

<!-- Bestehende Tokens -->
<div class="card shadow"><div class="card-body">
<h4 class="card-title">Bestehende Tokens</h4>
<?php if(empty($tokens)){ echo "<p class='text-muted'>Keine Tokens vorhanden.</p>"; } else { ?>
<div class="table-responsive"><table class="table table-striped table-bordered align-middle">
<thead class="table-light"><tr>
<th>Token</th><th>Dateien</th><th>Downloads</th><th>Ablauf</th><th>Link</th><th>Aktion</th>
</tr></thead>
<tbody>
<?php foreach($tokens as $tk=>$entry){ ?>
<tr>
<td><code><?= substr($tk,0,10) ?>...</code></td>
<td><?= implode(", ", $entry['files']) ?></td>
<td>
<?php 
$dl = [];
foreach($entry['files'] as $f){
    $count = $entry['downloads'][$f] ?? 0;
    $max = $entry['maxDownloads'] ?? 5;
    $dl[] = htmlspecialchars($f)." ($count/$max)";
}
echo implode("<br>", $dl);
?>
</td>
<td><?= date("d.m.Y H:i",$entry['expires']) ?></td>
<td>
<div class="d-flex gap-2">
<a href="<?= tokenLink($tk) ?>" target="_blank" class="btn btn-sm btn-primary">🔗 Öffnen</a>
<button class="btn btn-sm btn-secondary" onclick="copyLink('<?= $tk ?>')">📋 Kopieren</button>
</div>
</td>
<td><a href="?delete=<?= $tk ?>" class="btn btn-sm btn-danger" onclick="return confirm('Token wirklich löschen?');">❌ Löschen</a></td>
</tr>
<?php } ?>
</tbody></table></div><?php } ?>
</div></div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function copyLink(token){
    const link = `${window.location.origin}${'<?= dirname($_SERVER['SCRIPT_NAME']) ?>'}/download.php?token=${token}`;
    navigator.clipboard.writeText(link).then(()=>{ alert('Link kopiert: '+link); }).catch(err=>{ alert('Fehler beim Kopieren: '+err); });
}
</script>

<?php
if(isset($_GET['logout'])){ session_destroy(); header("Location: admin.php"); exit; }
?>
</body></html>
