<?php
session_start();
if (isset($_SESSION['admin'])) header("Location: newsletter_admin.php");

$config = require "config.php";
$pdo = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
               $config['db_user'], $config['db_pass']);

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = trim($_POST['user']);
    $pass = $_POST['pass'];
    $stmt = $pdo->prepare("SELECT * FROM newsletter_admin WHERE benutzername=?");
    $stmt->execute([$user]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$admin) $error = "Benutzername nicht gefunden!";
    elseif (!password_verify($pass, $admin['passwort'])) $error = "Passwort stimmt nicht!";
    else {
        $_SESSION['admin'] = $user;
        header("Location: newsletter_admin.php");
        exit;
    }
}
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5" style="max-width:400px;">
    <h2>Admin Login</h2>
    <?php if($error) echo "<div class='alert alert-danger'>$error</div>"; ?>
    <form method="POST" class="mt-3">
        <input type="text" name="user" class="form-control mb-3" placeholder="Benutzername" required>
        <input type="password" name="pass" class="form-control mb-3" placeholder="Passwort" required>
        <button type="submit" class="btn btn-primary w-100">Login</button>
    </form>
</div>
</body>
</html>
