<?php
require_once '../config.php';

// Session starten, falls noch nicht aktiv
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$erreur = "";

// reCAPTCHA-Einstellungen holen
$stmt = $conn->prepare("SELECT recaptcha_active, recaptcha_sitekey, recaptcha_secretkey FROM settings WHERE id = 1");
$stmt->execute();
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

$recaptcha_active = (int)($settings['recaptcha_active'] ?? 0) === 1;
$siteKey = $settings['recaptcha_sitekey'] ?? '';
$secretKey = $settings['recaptcha_secretkey'] ?? '';

// CSRF-Token generieren
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// POST-Login
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // CSRF prüfen
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        $erreur = "Ungültiger Sicherheits-Token.";
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        $recaptcha_ok = true;

        // reCAPTCHA prüfen
        if ($recaptcha_active) {
            $recaptcha_response = $_POST['g-recaptcha-response'] ?? '';
            if (!empty($recaptcha_response)) {
                $response = file_get_contents(
                    "https://www.google.com/recaptcha/api/siteverify?secret=" . urlencode($secretKey) . "&response=" . urlencode($recaptcha_response)
                );
                $responseKeys = json_decode($response, true);
                $recaptcha_ok = $responseKeys["success"] ?? false;
            } else {
                $recaptcha_ok = false;
            }
        }

        if ($recaptcha_ok) {
            $stmt = $conn->prepare("SELECT * FROM admins WHERE benutzername = ?");
            $stmt->execute([$username]);
            $admin = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($admin && password_verify($password, $admin['passwort'])) {
                session_regenerate_id(true); // Session-Fixation verhindern
                $_SESSION["connecte"] = $admin['benutzername'];
                header("Location: dashboard.php");
                exit;
            } else {
                $erreur = "Benutzername oder Passwort ist falsch.";
            }
        } else {
            $erreur = "Bitte bestätigen Sie das reCAPTCHA.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Admin-Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <?php if ($recaptcha_active): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="card p-4 shadow-sm">
        <h2>Administrator-Anmeldung</h2>
        <?php if (!empty($erreur)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($erreur, ENT_QUOTES, 'UTF-8') ?></div>
        <?php endif; ?>
        <form method="post" novalidate>
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token']) ?>">
            <div class="mb-3">
                <label for="username" class="form-label">Benutzername</label>
                <input type="text" id="username" name="username" class="form-control" required autocomplete="username">
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Passwort</label>
                <input type="password" id="password" name="password" class="form-control" required autocomplete="current-password">
            </div>

            <?php if ($recaptcha_active): ?>
                <div class="g-recaptcha mb-3" data-sitekey="<?= htmlspecialchars($siteKey, ENT_QUOTES, 'UTF-8') ?>"></div>
            <?php endif; ?>

            <button class="btn btn-primary">Anmelden</button>
        </form>
    </div>
</div>
</body>
</html>
