<?php
session_start();
require_once '../config.php';
if (!isset($_SESSION["connecte"])) {
    header("Location: index.php");
    exit;
}

// Bestehende Einstellungen laden
$stmt = $conn->query("SELECT * FROM settings WHERE id = 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC) ?? [];
$settings += [
    'recaptcha_active' => 0,
    'recaptcha_sitekey' => '',
    'recaptcha_secretkey' => '',
    'news_par_page' => 5,
    'card_hintergrund' => '#f8f9fa',  // Standard für Card-Hintergrund
    'body_hintergrund' => '#f8f9fa'   // Standard für Body-Hintergrund
];

// Speicherung der Einstellungen
$message = "";
if ($_SERVER["REQUEST_METHOD"] === "POST" && !isset($_POST["changer_mdp"])) {
    $headerfarbe = $_POST["headerfarbe"] ?? '#0d6efd';
    $bildBreite = (int)($_POST["bild_breite"] ?? 300);
    $textHintergrund = $_POST["text_hintergrund"] ?? '#ffffff';
    $cardHintergrund = $_POST["card_hintergrund"] ?? '#f8f9fa';
    $bodyHintergrund = $_POST["body_hintergrund"] ?? '#f8f9fa';

    $recaptchaActive = isset($_POST["recaptcha_active"]) ? 1 : 0;
    $recaptchaSitekey = $_POST["recaptcha_sitekey"] ?? '';
    $recaptchaSecretkey = $_POST["recaptcha_secretkey"] ?? '';
    $newsParPage = (int)($_POST["news_par_page"] ?? 3);

    $stmt = $conn->prepare("UPDATE settings SET headerfarbe=?, bild_breite=?, text_hintergrund=?, card_hintergrund=?, body_hintergrund=?, recaptcha_active=?, recaptcha_sitekey=?, recaptcha_secretkey=?, news_par_page=? WHERE id=1");
    $stmt->execute([$headerfarbe, $bildBreite, $textHintergrund, $cardHintergrund, $bodyHintergrund, $recaptchaActive, $recaptchaSitekey, $recaptchaSecretkey, $newsParPage]);

    $message = "Parameter gespeichert";

    $settings['headerfarbe'] = $headerfarbe;
    $settings['bild_breite'] = $bildBreite;
    $settings['text_hintergrund'] = $textHintergrund;
    $settings['card_hintergrund'] = $cardHintergrund;
    $settings['body_hintergrund'] = $bodyHintergrund;
    $settings['recaptcha_active'] = $recaptchaActive;
    $settings['recaptcha_sitekey'] = $recaptchaSitekey;
    $settings['recaptcha_secretkey'] = $recaptchaSecretkey;
    $settings['news_par_page'] = $newsParPage;
}

// Passwort ändern
$passwordMessage = "";
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["changer_mdp"])) {
    $ancien = $_POST["ancien_mdp"] ?? '';
    $nouveau = $_POST["nouveau_mdp"] ?? '';
    $confirmation = $_POST["confirmation_mdp"] ?? '';

    $stmt = $conn->prepare("SELECT * FROM admins WHERE benutzername = ?");
    $stmt->execute([$_SESSION["connecte"]]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$admin || !password_verify($ancien, $admin['passwort'])) {
        $passwordMessage = '<div class="alert alert-danger">Aktuelles Passwort ist falsch.</div>';
    } elseif ($nouveau !== $confirmation) {
        $passwordMessage = '<div class="alert alert-warning">Die neuen Passwörter stimmen nicht überein.</div>';
    } else {
        $nouveauHash = password_hash($nouveau, PASSWORD_DEFAULT);
        $update = $conn->prepare("UPDATE admins SET passwort = ?, passwort_geaendert = 1 WHERE benutzername = ?");
        $update->execute([$nouveauHash, $_SESSION["connecte"]]);
        $passwordMessage = '<div class="alert alert-success">Passwort erfolgreich aktualisiert.</div>';
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Website-Einstellungen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h2>Website-Einstellungen</h2>
    <?php if ($message): ?>
    <div class="alert alert-success" id="successMessage"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
    <form method="post">
        <div class="mb-3">
            <label>Kopfzeilenfarbe</label>
            <input type="color" name="headerfarbe" value="<?= htmlspecialchars($settings['headerfarbe']) ?>" class="form-control form-control-color" required>
        </div>
        <div class="mb-3">
            <label>Maximale Bildbreite (px)</label>
            <input type="number" name="bild_breite" value="<?= htmlspecialchars($settings['bild_breite']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Texthintergrundfarbe</label>
            <input type="color" name="text_hintergrund" value="<?= htmlspecialchars($settings['text_hintergrund']) ?>" class="form-control form-control-color" required>
        </div>
        <div class="mb-3">
            <label>Hintergrundfarbe der News-Cards</label>
            <input type="color" name="card_hintergrund" value="<?= htmlspecialchars($settings['card_hintergrund']) ?>" class="form-control form-control-color" required>
        </div>
        <div class="mb-3">
            <label>Hintergrundfarbe der gesamten Seite (Body)</label>
            <input type="color" name="body_hintergrund" value="<?= htmlspecialchars($settings['body_hintergrund']) ?>" class="form-control form-control-color" required>
        </div>
        <div class="mb-3">
            <label>Anzahl der Nachrichten pro Seite</label>
            <input type="number" name="news_par_page" value="<?= htmlspecialchars($settings['news_par_page']) ?>" class="form-control" min="1" required>
        </div>
        <h5>🔐 Google reCAPTCHA v2</h5>
        <div class="form-check mb-3">
            <input type="checkbox" name="recaptcha_active" value="1" <?= (!empty($settings['recaptcha_active']) && $settings['recaptcha_active']) ? 'checked' : '' ?>>
            <label class="form-check-label">ReCAPTCHA auf der Anmeldeseite aktivieren</label>
        </div>
        <div class="mb-3">
            <label>Site Key</label>
            <input type="text" name="recaptcha_sitekey" value="<?= htmlspecialchars($settings['recaptcha_sitekey'] ?? '') ?>" class="form-control">
        </div>
        <div class="mb-3">
            <label>Secret Key</label>
            <input type="text" name="recaptcha_secretkey" value="<?= htmlspecialchars($settings['recaptcha_secretkey'] ?? '') ?>" class="form-control">
        </div>
        <button class="btn btn-primary">Speichern</button>
        <a href="dashboard.php" class="btn btn-secondary">Zurück</a>
    </form>
</div>
<br><br>
<div class="container">
    <h2>Passwort ändern</h2>
    <?= $passwordMessage ?>
    <form method="post">
        <input type="hidden" name="changer_mdp" value="1">
        <div class="mb-3">
            <label>Aktuelles Passwort</label>
            <input type="password" name="ancien_mdp" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Neues Passwort</label>
            <input type="password" name="nouveau_mdp" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Neues Passwort bestätigen</label>
            <input type="password" name="confirmation_mdp" class="form-control" required>
        </div>
        <button class="btn btn-warning">Passwort ändern</button>
        <a href="dashboard.php" class="btn btn-secondary">Zurück</a>
    </form>
</div>
<script>
    setTimeout(() => {
        document.getElementById("successMessage")?.remove();
    }, 3000);
</script>
</body>
</html>
