<?php
require 'config.php';

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: admin_profile.php");
    exit;
}

$old = trim($_POST['oldpass']);
$new = trim($_POST['newpass']);
$new2= trim($_POST['newpass2']);

if ($new !== $new2) {
    die("<p style='color:red;'>❌ Neue Passwörter stimmen nicht überein!</p>
         <p><a href='admin_profile.php'>Zurück</a></p>");
}

// Aktuelles Passwort prüfen
$stmt = $pdo->query("SELECT password FROM admin_users WHERE id=1 LIMIT 1");
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row || !password_verify($old, $row['password'])) {
    die("<p style='color:red;'>❌ Altes Passwort ist falsch!</p>
         <p><a href='admin_profile.php'>Zurück</a></p>");
}

// Neues Passwort verschlüsseln
$newHash = password_hash($new, PASSWORD_BCRYPT);

// Speichern
$upd = $pdo->prepare("UPDATE admin_users SET password = :p WHERE id=1");
$upd->execute([':p' => $newHash]);

echo "<h3 style='color:green;'>✔ Passwort erfolgreich geändert!</h3>
      <p><a href='dashboard.php'>Zurück zum Dashboard</a></p>";
