<?php
require 'config.php';
ini_set('display_errors',1);
error_reporting(E_ALL);

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

/* Werte zusammenbauen */

$excludedFolders = isset($_POST['excluded_folders']) ? $_POST['excluded_folders'] : [];
$allowedExtensions = isset($_POST['allowed_extensions']) ? $_POST['allowed_extensions'] : [];
$protectedPatterns = trim($_POST['protected_patterns'] ?? '');
$resultMode        = $_POST['result_mode'] ?? 'inline';
$searchLimit       = intval($_POST['search_limit'] ?? 20);
$pdfPath           = trim($_POST['pdf_path'] ?? '');
$widgetCss         = $_POST['widget_css'] ?? '';

$stmt = $pdo->prepare("
    UPDATE search_settings SET 
        result_mode = :rm,
        search_limit = :sl,
        widget_css = :css,
        pdf_path = :pdf,
        excluded_folders = :exf,
        allowed_extensions = :ext,
        protected_patterns = :prot,
        updated_at = datetime('now')
    WHERE id = 1
");

$stmt->execute([
    ':rm'   => $resultMode,
    ':sl'   => $searchLimit,
    ':css'  => $widgetCss,
    ':pdf'  => $pdfPath,
    ':exf'  => json_encode($excludedFolders),
    ':ext'  => json_encode($allowedExtensions),
    ':prot' => $protectedPatterns,
]);

header("Location: dashboard.php");
exit;
