<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../admin/config.php';
require_once __DIR__ . '/../classes/SearchEngine.php';

$engine = new SearchEngine($pdo);
$q      = isset($_GET['q']) ? trim($_GET['q']) : '';

$results = $engine->search($q);

$page     = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$perPage  = 10;
$total    = count($results);
$offset   = ($page - 1) * $perPage;
$resultsPaged = array_slice($results, $offset, $perPage);
$totalPages = ceil($total / $perPage);
?>

<h3>Suchergebnisse für: "<?= htmlspecialchars($q) ?>"</h3>

<?php if (empty($results)): ?>
    <p>Keine Ergebnisse gefunden.</p>

<?php else: ?>

    <?php foreach ($resultsPaged as $r): ?>
        <div class="result-card">

            <!-- TITEL + URL -->
            <div class="result-title">
                <?php
                // === ZUVERLÄSSIGE URL ERMITTLUNG ===
                if (!empty($r['url'])) {
                    $url = $r['url'];     // DB- oder File-Suchobjekt mit url
                } elseif (!empty($r['file'])) {
                    // Dateisystemtreffer ohne url
                    $url = str_replace($_SERVER['DOCUMENT_ROOT'], '', $r['file']);
                } else {
                    $url = '#';
                }

                // Name fallback
                $name = !empty($r['name']) ? $r['name'] : basename($url);
                ?>

                <a href="<?= htmlspecialchars($url) ?>" target="_blank">
                    <?= htmlspecialchars($name) ?>
                </a>
            </div>

            <!-- META -->
            <div class="result-meta">
                <?php
                $type = !empty($r['type']) ? $r['type'] : 'unbekannt';
                ?>
                <small>(Quelle: <?= htmlspecialchars($type) ?>)</small>
            </div>

            <!-- PREVIEW -->
            <?php if (!empty($r['preview'])): ?>
                <div class="result-preview">
                    <?= $r['preview'] ?>
                </div>
            <?php endif; ?>

        </div>
    <?php endforeach; ?>

    <!-- PAGINATION -->
    <?php if ($totalPages > 1): ?>
        <div class="pagination">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <a
                    href="?q=<?= urlencode($q) ?>&page=<?= $i ?>"
                    class="<?= ($i == $page) ? 'active' : '' ?>"
                ><?= $i ?></a>
            <?php endfor; ?>
        </div>
    <?php endif; ?>

<?php endif; ?>
