<?php
require_once __DIR__ . '/../admin/config.php';
require_once __DIR__ . '/../classes/SearchEngine.php';

$engine    = new SearchEngine($pdo);
$settings  = $engine->getSettings();

$resultMode = $settings['result_mode'] ?? 'inline';
$q          = isset($_GET['q']) ? trim($_GET['q']) : '';
$extFilter  = $_GET['ext'] ?? '';
?>

<style>
/* X wird nur angezeigt, wenn Text existiert */
.clear-x {
    cursor: pointer;
    display: none;
    user-select: none;
}

.clear-x.show {
    display: inline-flex;
}

.clear-x svg {
    width: 20px;
    height: 20px;
    stroke: #777;
}

.clear-x:hover svg {
    stroke: #333;
    transform: scale(1.15);
    transition: transform 0.15s ease;
}
</style>

<!-- ================= SUCHWIDGET ================= -->
<div class="suche-widget" data-result-mode="<?= $resultMode ?>">

<form id="sucheForm" method="get">

    <input id="searchInput" type="text" name="q" placeholder="Suchbegriff..." 
        value="<?= htmlspecialchars($q) ?>">

    <select id="extInput" name="ext" style="padding:3px; margin-left:5px;">
        <option value="">Alle</option>
        <option value="pdf"  <?= $extFilter === 'pdf' ? 'selected':'' ?>>PDF</option>
        <option value="html" <?= $extFilter === 'html' ? 'selected':'' ?>>HTML</option>
        <option value="php"  <?= $extFilter === 'php' ? 'selected':'' ?>>PHP</option>
        <option value="txt"  <?= $extFilter === 'txt' ? 'selected':'' ?>>TXT</option>
    </select>

    <button type="submit">🔍</button>

    <!-- CLEAR-X (sichtbar wenn Q existiert) -->
    <span id="clearX" class="clear-x <?= $q ? 'show' : '' ?>">
        <svg viewBox="0 0 24 24">
            <path d="M6 6L18 18M6 18L18 6" stroke-width="2"/>
        </svg>
    </span>
</form>

</div>

<script>
document.addEventListener('DOMContentLoaded', function(){

    var form    = document.getElementById('sucheForm');
    var input   = document.getElementById('searchInput');
    var extSel  = document.getElementById('extInput');
    var clearX  = document.getElementById('clearX');

    /* ================= SAFE SUBMIT ================= */
    form.addEventListener('submit', function(e){
        e.preventDefault();

        var q   = input.value.trim();
        var ext = extSel.value.trim();

        if (!q) return;

        var encodedQ = encodeURIComponent(q);
        var encodedExt = encodeURIComponent(ext);

        /* EXT IMMER MITGEBEN – ganz wichtig! */
        var url = window.location.pathname + '?q=' + encodedQ;

        if (ext !== '') {
            url += '&ext=' + encodedExt;
        }

        window.location.href = url;
    });

    /* X EIN-/AUSBLENDEN */
    input.addEventListener('input', function(){
        if (this.value.trim() !== '') {
            clearX.classList.add('show');
        } else {
            clearX.classList.remove('show');
        }
    });

    /* X KLICK = alles reset + URL clean */
    clearX.addEventListener('click', function(){
        input.value = '';
        clearX.classList.remove('show');

        /* ext auch zurücksetzen */
        extSel.value = '';

        /* Voll reset */
        window.location.href = window.location.origin + window.location.pathname;
    });
});
</script>

<?php if ($q !== ''): ?>
    <div id="searchResults">
        <?php include __DIR__ . '/search_results.php'; ?>
    </div>
<?php endif; ?>

<?php if ($resultMode === 'modal'): ?>
<div class="modal fade" id="searchModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Suchergebnisse</h5>
        <button type="button" class="close" data-bs-dismiss="modal">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body" id="searchModalBody"></div>
    </div>
  </div>
</div>
<?php endif; ?>
