<?php
// Error reporting aktivieren für Debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'phpmailer/src/Exception.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/SMTP.php';

$config = require "config.php";
$pdo = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
               $config['db_user'], $config['db_pass']);

$message = '';
$messageType = '';

// Bestätigung verarbeiten
if (isset($_GET['confirm']) && isset($_GET['token'])) {
    $token = $_GET['token'];
    
    // Token aus Datenbank suchen
    $stmt = $pdo->prepare("SELECT email FROM newsletter_pending WHERE token = ? AND erstellt_am > DATE_SUB(NOW(), INTERVAL 24 HOUR)");
    $stmt->execute([$token]);
    $pendingEmail = $stmt->fetchColumn();
    
    if ($pendingEmail) {
        // E-Mail in aktive Abonnenten übertragen
        $stmt = $pdo->prepare("INSERT IGNORE INTO newsletter_abonnenten (email) VALUES (?)");
        $result = $stmt->execute([$pendingEmail]);
        
        // Pending-Eintrag löschen
        $stmt = $pdo->prepare("DELETE FROM newsletter_pending WHERE token = ?");
        $stmt->execute([$token]);
        
        if ($stmt->rowCount() > 0) {
            $message = 'Vielen Dank! Ihre E-Mail-Adresse wurde erfolgreich für den Newsletter bestätigt.';
            $messageType = 'success';
        } else {
            $message = 'Diese E-Mail-Adresse ist bereits für den Newsletter angemeldet.';
            $messageType = 'info';
        }
    } else {
        $message = 'Ungültiger oder abgelaufener Bestätigungslink. Bitte melden Sie sich erneut an.';
        $messageType = 'danger';
    }
}

// Anmeldung verarbeiten
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'])) {
    $email = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
    
    if ($email) {
        // Prüfen ob bereits angemeldet
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM newsletter_abonnenten WHERE email = ?");
        $stmt->execute([$email]);
        $exists = $stmt->fetchColumn();
        
        if ($exists) {
            $message = 'Diese E-Mail-Adresse ist bereits für den Newsletter angemeldet.';
            $messageType = 'info';
        } else {
            // Token generieren
            $token = bin2hex(random_bytes(32));
            
            // In Pending-Tabelle speichern (alte Einträge überschreiben)
            $stmt = $pdo->prepare("REPLACE INTO newsletter_pending (email, token, erstellt_am) VALUES (?, ?, NOW())");
            $stmt->execute([$email, $token]);
            
            // Bestätigungs-E-Mail senden
            $mail = new PHPMailer(true);
            
            try {
                $mail->CharSet = 'UTF-8';
                $mail->isSMTP();
                $mail->Host = 'localhost';
                $mail->SMTPAuth = false;
                $mail->Port = 25;

                // ==== Optional SMTP: aktivieren wenn gewünscht ====
                /*
                $mail->isSMTP();
                $mail->Host = 'smtp.deinedomain.de';
                $mail->SMTPAuth = true;
                $mail->Username = 'dein_smtp_user';
                $mail->Password = 'dein_smtp_passwort';
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // oder ENCRYPTION_SMTPS
                $mail->Port = 587; // SMTP-Port
                */

                $mail->setFrom('newsletter@deinedomain.de', 'Newsletter');
                $mail->addAddress($email);

                $confirmLink = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?confirm=1&token=' . $token;

                $mail->isHTML(true);
                $mail->Subject = 'Newsletter-Anmeldung bestätigen';
                $mail->Body = "
                <html>
                <head>
                    <meta charset='utf-8'>
                    <style>
                        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                        .header { background: #007bff; color: white; padding: 20px; text-align: center; }
                        .content { padding: 20px; background: #f8f9fa; }
                        .button { display: inline-block; padding: 12px 24px; background: #28a745; color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
                        .footer { padding: 20px; font-size: 12px; color: #666; text-align: center; }
                    </style>
                </head>
                <body>
                    <div class='container'>
                        <div class='header'>
                            <h2>Newsletter-Anmeldung bestätigen</h2>
                        </div>
                        <div class='content'>
                            <h3>Hallo!</h3>
                            <p>Sie haben sich für unseren Newsletter angemeldet. Bitte bestätigen Sie Ihre Anmeldung, indem Sie auf den folgenden Link klicken:</p>
                            <p style='text-align: center;'>
                                <a href='$confirmLink' class='button'>Newsletter-Anmeldung bestätigen</a>
                            </p>
                            <p><strong>Oder kopieren Sie diesen Link in Ihren Browser:</strong><br>
                            <a href='$confirmLink'>$confirmLink</a></p>
                            <p><small>Dieser Link ist 24 Stunden gültig. Falls Sie sich nicht für den Newsletter angemeldet haben, können Sie diese E-Mail ignorieren.</small></p>
                        </div>
                        <div class='footer'>
                            <p>Diese E-Mail wurde automatisch versendet. Bitte antworten Sie nicht auf diese E-Mail.</p>
                        </div>
                    </div>
                </body>
                </html>
                ";
                
                $mail->AltBody = "Newsletter-Anmeldung bestätigen\n\n"
                               . "Sie haben sich für unseren Newsletter angemeldet. "
                               . "Bitte bestätigen Sie Ihre Anmeldung über folgenden Link:\n\n"
                               . "$confirmLink\n\n"
                               . "Dieser Link ist 24 Stunden gültig.";

                $mail->send();
                
                $message = 'Danke für Ihre Anmeldung! Wir haben Ihnen eine Bestätigungs-E-Mail gesendet. Bitte klicken Sie auf den Link in der E-Mail, um Ihre Anmeldung zu vervollständigen.';
                $messageType = 'success';
                
            } catch (Exception $e) {
                $message = 'Fehler beim Versenden der Bestätigungs-E-Mail. Bitte versuchen Sie es später erneut.';
                $messageType = 'danger';
            }
        }
    } else {
        $message = 'Bitte geben Sie eine gültige E-Mail-Adresse ein.';
        $messageType = 'danger';
    }
}
?>

<!doctype html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Newsletter Anmeldung</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .signup-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .card-body {
            padding: 2rem;
        }
        .btn-newsletter {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        .btn-newsletter:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
    </style>
	 <!-- Resize-Skript -->
    <script>
        window.addEventListener("load", fenster);
        window.addEventListener("resize", fenster);
        function fenster() {
          if (parent.document.getElementsByTagName("iframe")[0]) {
            parent.document.getElementsByTagName("iframe")[0].style.height =
              document.getElementsByTagName("html")[0].offsetHeight +'px';
          }
        }
    </script>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="signup-card">
                    <div class="card-header">
                        <h2 class="mb-0">
                            <i class="fas fa-envelope me-2"></i>Newsletter
                        </h2>
                        <p class="mb-0 mt-2 opacity-90">Bleiben Sie auf dem Laufenden!</p>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-<?= $messageType ?> alert-dismissible fade show" role="alert">
                                <i class="fas fa-<?= $messageType === 'success' ? 'check-circle' : ($messageType === 'info' ? 'info-circle' : 'exclamation-triangle') ?> me-2"></i>
                                <?= $message ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <?php if (!isset($_GET['confirm'])): ?>
                            <form method="POST" class="needs-validation" novalidate>
                                <div class="mb-4">
                                    <label for="email" class="form-label fw-semibold">
                                        <i class="fas fa-at me-1"></i>E-Mail-Adresse
                                    </label>
                                    <input type="email" 
                                           class="form-control form-control-lg" 
                                           id="email" 
                                           name="email" 
                                           placeholder="ihre.email@example.com"
                                           required>
                                    <div class="invalid-feedback">
                                        Bitte geben Sie eine gültige E-Mail-Adresse ein.
                                    </div>
                                </div>
                                
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary btn-lg btn-newsletter">
                                        <i class="fas fa-paper-plane me-2"></i>Für Newsletter anmelden
                                    </button>
                                </div>
                            </form>
                            
                            <div class="mt-4 p-3 bg-light rounded">
                                <div class="d-flex align-items-start">
                                    <i class="fas fa-shield-alt text-success me-3 mt-1"></i>
                                    <div>
                                        <h6 class="mb-1">Datenschutz & Bestätigung</h6>
                                        <small class="text-muted">
                                            Nach der Anmeldung erhalten Sie eine Bestätigungs-E-Mail. 
                                            Erst nach Klick auf den Bestätigungslink sind Sie für den Newsletter angemeldet. 
                                            Ihre Daten werden sicher behandelt und nicht an Dritte weitergegeben.
                                        </small>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if (isset($_GET['confirm']) && $messageType === 'success'): ?>
                            <div class="text-center">
                                <i class="fas fa-check-circle text-success" style="font-size: 3rem;"></i>
                                <h4 class="mt-3 text-success">Bestätigung erfolgreich!</h4>
                                <p class="text-muted">Sie erhalten ab sofort unseren Newsletter.</p>
                                <a href="<?= strtok($_SERVER["REQUEST_URI"], '?') ?>" class="btn btn-primary">
                                    <i class="fas fa-home me-2"></i>Zurück zur Anmeldung
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Bootstrap form validation
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                var validation = Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();
    </script>
</body>
</html>