<?php
session_start();

// 2026 Volker Niederastroth
/* ===== LOGIN ===== */
$ADMIN_USER = "admin";
$ADMIN_PASS = "claus123";

if (isset($_POST["logout"])) {
    session_destroy();
    header("Location: index.php");
    exit;
}

if (!isset($_SESSION["ok"])) {
    if (!empty($_POST["user"]) && !empty($_POST["pass"]) &&
        $_POST["user"] === $ADMIN_USER && $_POST["pass"] === $ADMIN_PASS) {
        $_SESSION["ok"] = true;
        header("Location: index.php");
        exit;
    }
    ?>
    <!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Kalender Login</title>

<style>
body{
  margin:0;
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
  background:linear-gradient(135deg,#f2e6d9,#f7f8fa);
  font-family:system-ui,-apple-system,Segoe UI,Arial,sans-serif;
}

.login-card{
  background:#fff;
  padding:30px 32px 34px;
  border-radius:14px;
  width:100%;
  max-width:380px;
  box-shadow:0 20px 50px rgba(0,0,0,.15);
}

.login-card h1{
  margin:0 0 10px;
  text-align:center;
  color:#a05408;
  font-size:26px;
}

.login-card p{
  text-align:center;
  margin:0 0 22px;
  color:#666;
  font-size:14px;
}

.login-card label{
  display:block;
  font-size:13px;
  font-weight:600;
  margin-bottom:6px;
  color:#333;
}

.login-card input{
  width:100%;
  padding:11px 12px;
  margin-bottom:14px;
  border-radius:8px;
  border:1px solid #ddd;
  font-size:14px;
}

.login-card input:focus{
  outline:none;
  border-color:#a05408;
}

.login-card button{
  width:100%;
  padding:12px;
  border:none;
  border-radius:8px;
  background:#a05408;
  color:#fff;
  font-size:15px;
  font-weight:600;
  cursor:pointer;
}

.login-card button:hover{
  opacity:.9;
}

.login-footer{
  margin-top:16px;
  text-align:center;
  font-size:12px;
  color:#999;
}
</style>
</head>

<body>

<form method="post" class="login-card">
  <h1>📅 Kalender Admin</h1>
  <p>Bitte melden Sie sich an</p>

  <label>Benutzername</label>
  <input name="user" autocomplete="username" required>

  <label>Passwort</label>
  <input name="pass" type="password" autocomplete="current-password" required>

  <button>Anmelden</button>

  <div class="login-footer">
    Bürgerverein Borgfeld
  </div>
</form>

</body>
</html>
<?php
exit;

}

/* ===== DB ===== */
$dbDir  = __DIR__ . '/../data';
$dbFile = $dbDir . '/events.sqlite';
if (!is_dir($dbDir)) mkdir($dbDir, 0775, true);

$db = new PDO('sqlite:' . $dbFile);
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$db->exec("
CREATE TABLE IF NOT EXISTS events (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    event_date TEXT NOT NULL,
    event_time TEXT DEFAULT '',
    title TEXT NOT NULL,
    time_html TEXT NOT NULL,
    desc TEXT DEFAULT '',
    link TEXT DEFAULT '',
    created_at TEXT DEFAULT (datetime('now')),
    updated_at TEXT DEFAULT (datetime('now'))
);
");

/* ===== SAVE / DELETE ===== */
if (($_POST["action"] ?? '') === 'save') {
    $id = $_POST["id"] ?? '';
    $event_date = str_replace('.', '-', trim($_POST["event_date"] ?? ''));
    $event_time = trim($_POST["event_time"] ?? '');
    $title = trim($_POST["title"] ?? '');
    $time_html = trim($_POST["time_html"] ?? '');
    $desc = trim($_POST["desc"] ?? '');
    $link = trim($_POST["link"] ?? '');

    if ($id) {
        $stmt = $db->prepare("
          UPDATE events
          SET event_date=?, event_time=?, title=?, time_html=?, desc=?, link=?, updated_at=datetime('now')
          WHERE id=?
        ");
        $stmt->execute([$event_date,$event_time,$title,$time_html,$desc,$link,$id]);
    } else {
        $stmt = $db->prepare("
          INSERT INTO events (event_date,event_time,title,time_html,desc,link)
          VALUES (?,?,?,?,?,?)
        ");
        $stmt->execute([$event_date,$event_time,$title,$time_html,$desc,$link]);
    }
    header("Location: index.php"); exit;
}

if (($_POST["action"] ?? '') === 'delete') {
    $stmt = $db->prepare("DELETE FROM events WHERE id=?");
    $stmt->execute([$_POST["id"]]);
    header("Location: index.php"); exit;
}

$edit = null;
if (isset($_GET["edit"])) {
    $stmt = $db->prepare("SELECT * FROM events WHERE id=?");
    $stmt->execute([$_GET["edit"]]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}

$rows = $db->query("SELECT * FROM events ORDER BY event_date DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Kalender Admin</title>

<script src="./tinymce/tinymce.min.js"></script>

<style>
:root{
  --bg:#f4f6f8;
  --card:#ffffff;
  --accent:#a05408;
  --accent-soft:#f2e6d9;
  --border:#ddd;
  --text:#333;
}

*{box-sizing:border-box}

body{
  margin:0;
  font-family:system-ui,-apple-system,Segoe UI,Arial,sans-serif;
  background:var(--bg);
  color:var(--text);
}
body{
  margin:0;
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
  background:linear-gradient(135deg,#f2e6d9,#f7f8fa);
  font-family:system-ui,-apple-system,Segoe UI,Arial,sans-serif;
}

.login-card{
  background:#fff;
  padding:30px 32px 34px;
  border-radius:14px;
  width:100%;
  max-width:380px;
  box-shadow:0 20px 50px rgba(0,0,0,.15);
}

.login-card h1{
  margin:0 0 10px;
  text-align:center;
  color:#a05408;
  font-size:26px;
}

.login-card p{
  text-align:center;
  margin:0 0 22px;
  color:#666;
  font-size:14px;
}

.login-card label{
  display:block;
  font-size:13px;
  font-weight:600;
  margin-bottom:6px;
  color:#333;
}

.login-card input{
  width:100%;
  padding:11px 12px;
  margin-bottom:14px;
  border-radius:8px;
  border:1px solid #ddd;
  font-size:14px;
}

.login-card input:focus{
  outline:none;
  border-color:#a05408;
}

.login-card button{
  width:100%;
  padding:12px;
  border:none;
  border-radius:8px;
  background:#a05408;
  color:#fff;
  font-size:15px;
  font-weight:600;
  cursor:pointer;
}

.login-card button:hover{
  opacity:.9;
}

.login-footer{
  margin-top:16px;
  text-align:center;
  font-size:12px;
  color:#999;
}
.container{
  max-width:1100px;
  margin:40px auto;
  padding:0 20px;
}

header{
  display:flex;
  justify-content:space-between;
  align-items:center;
  margin-bottom:25px;
}

header h1{
  margin:0;
  color:var(--accent);
  font-size:28px;
}

.card{
  background:var(--card);
  border-radius:12px;
  padding:24px;
  margin-bottom:28px;
  box-shadow:0 8px 24px rgba(0,0,0,.08);
}

.card h2{
  margin-top:0;
  color:var(--accent);
}

form.grid{
  display:grid;
  grid-template-columns:1fr 1fr;
  gap:18px;
}

label{
  font-size:14px;
  font-weight:600;
  margin-bottom:6px;
  display:block;
}

input, textarea{
  width:100%;
  padding:10px 12px;
  border-radius:8px;
  border:1px solid var(--border);
  font-size:14px;
}

textarea{resize:vertical}

.full{grid-column:1 / -1}

.actions{
  display:flex;
  gap:10px;
  margin-top:10px;
}

button{
  background:var(--accent);
  color:#fff;
  border:none;
  border-radius:8px;
  padding:10px 18px;
  cursor:pointer;
  font-size:14px;
}

button.secondary{background:#999}
button.danger{background:#c0392b}

button:hover{opacity:.9}

table{
  width:100%;
  border-collapse:collapse;
  font-size:14px;
}

th,td{
  padding:12px;
  border-bottom:1px solid var(--border);
}

th{
  background:var(--accent-soft);
  text-align:left;
}

small{color:#666}

.logout button{
  background:#777;
}

@media(max-width:800px){
  form.grid{grid-template-columns:1fr}
}
</style>

<script>
tinymce.init({
  selector:'textarea.tinymce',
  language:'de',
  height:220,
  menubar:true,
  plugins:'lists link emoticons table code fullscreen',
  toolbar:'undo redo | fontfamily fontsize | bold italic underline | forecolor | bullist numlist |  emoticons | link | code fullscreen',
  font_size_formats:'12px 14px 16px 18px 20px 24px 28px 32px',
  fontsize_unit:'px',
  setup:function(ed){ed.on('change keyup',()=>tinymce.triggerSave());}
});
</script>
</head>

<body>
<div class="container">

<header>
  <h1>📅 Kalender Admin</h1>
  <form method="post" class="logout">
    <button name="logout">Logout</button>
  </form>
</header>

<div class="card">
  <h2><?= $edit ? "✏️ Termin bearbeiten" : "➕ Neuer Termin" ?></h2>

  <form method="post" class="grid">
    <input type="hidden" name="action" value="save">
    <input type="hidden" name="id" value="<?= htmlspecialchars($edit['id'] ?? '') ?>">

    <div>
      <label>Datum</label>
      <input type="date" name="event_date" required value="<?= htmlspecialchars($edit['event_date'] ?? '') ?>">
    </div>

    <div>
      <label>Uhrzeit</label>
      <input type="time" name="event_time" value="<?= htmlspecialchars($edit['event_time'] ?? '') ?>">
    </div>

    <div class="full">
      <label>Titel</label>
      <input name="title" required value="<?= htmlspecialchars($edit['title'] ?? '') ?>">
    </div>

    <div class="full">
      <label>Zeit / Ort</label>
      <textarea name="time_html" class="tinymce"><?= htmlspecialchars($edit['time_html'] ?? '') ?></textarea>
    </div>

    <div class="full">
      <label>Beschreibung</label>
      <textarea name="desc" class="tinymce"><?= htmlspecialchars($edit['desc'] ?? '') ?></textarea>
    </div>

    <div class="full">
      <label>Link (optional)</label>
      <input name="link" value="<?= htmlspecialchars($edit['link'] ?? '') ?>">
    </div>

    <div class="actions full">
      <button>Speichern</button>
      <?php if($edit): ?>
        <a href="index.php"><button type="button" class="secondary">Abbrechen</button></a>
      <?php endif; ?>
    </div>
  </form>
</div>

<div class="card">
  <h2>📋 Vorhandene Termine</h2>

  <table>
    <tr>
      <th>Datum</th>
      <th>Titel</th>
      <th>Aktionen</th>
    </tr>

    <?php foreach($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['event_date']) ?></td>
      <td><?= htmlspecialchars($r['title']) ?></td>
      <td>
        <a href="?edit=<?= (int)$r['id'] ?>"><button class="secondary">Bearbeiten</button></a>
        <form method="post" style="display:inline" onsubmit="return confirm('Wirklich löschen?')">
          <input type="hidden" name="action" value="delete">
          <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
          <button class="danger">Löschen</button>
        </form>
      </td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>

</div>
</body>
</html>
