<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

// --- Adminschutz (einfach) ---
$admin_pass = 'volker123'; // ändern!
if (isset($_GET['logout'])) { session_destroy(); header('Location: index.php'); exit; }
if (!isset($_SESSION['admin_ok'])) {
  if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['pw']??'')===$admin_pass) {
    $_SESSION['admin_ok'] = true; header('Location: index.php'); exit;
  }
  echo '<!DOCTYPE html><html lang="de"><head><meta charset="utf-8">
  <title>Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>body{background:#0f172a;color:#e2e8f0;display:flex;align-items:center;justify-content:center;height:100vh;}
  .card{background:#1e293b;border:none;box-shadow:0 0 25px rgba(0,0,0,.4);}</style></head>
  <body><form method="post" class="card p-4" style="min-width:300px;">
  <h4 class="mb-3 text-center">🔒 Admin Login</h4>
  <input type="password" name="pw" class="form-control mb-3" placeholder="Passwort" autofocus>
  <button class="btn btn-primary w-100">Login</button></form></body></html>'; exit;
}
echo '<div style="position:fixed;top:10px;right:10px;z-index:9999;"><a href="?logout=1" class="btn btn-danger btn-sm">🚪 Logout</a></div>';

require_once __DIR__ . '/functions.php';

// --- Server-weite Ordnersuche (unter DOCUMENT_ROOT) ---
function scan_dirs_server(string $root, int $depth = 3): array {
  $res = [];
  $root = rtrim(str_replace('\\','/', realpath($root) ?: $root), '/');
  if (!is_dir($root)) return [];
  $it = new RecursiveIteratorIterator(
    new RecursiveDirectoryIterator($root, FilesystemIterator::SKIP_DOTS),
    RecursiveIteratorIterator::SELF_FIRST
  );
  foreach ($it as $f) {
    if (!$f->isDir()) continue;
    $p = str_replace('\\','/', $f->getPathname());
    $relDepth = substr_count(str_replace($root,'',$p), '/');
    if ($relDepth > $depth) continue;
    // relative Anzeige ab DOCUMENT_ROOT
    $rel = ltrim(str_replace($root, '', $p), '/');
    if ($rel !== '' && !in_array($rel, $res, true)) $res[] = $rel;
  }
  sort($res);
  return $res;
}

// --- Config & Daten ---
$cfg = read_config();

// Ordnerliste (serverweit ab DOCUMENT_ROOT)
$dirs = scan_dirs_server($_SERVER['DOCUMENT_ROOT'], 3);
// praktische Defaults ergänzen
if (!in_array('bilder', $dirs, true) && is_dir(__DIR__ . '/bilder')) $dirs[] = 'bilder';

$sourceDir = $cfg['source_dir'] ?? 'bilder';
$images    = list_images($sourceDir);
$first     = count($images) > 0 ? safe_name($images[0]) : null;

// Fonts aus /assets
$fonts = glob(__DIR__ . '/assets/*.{ttf,otf}', GLOB_BRACE);
$fonts = array_map('basename', $fonts);

// Helper
function val($cfg, $key, $default = '') {
  return htmlspecialchars($cfg[$key] ?? $default, ENT_QUOTES);
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>💧 Wasserzeichen-Tool</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#0f172a;color:#e2e8f0;}
h2{color:#fff;text-align:center;margin-bottom:20px;}
label{color:#cbd5e1;}
.card{background:#1e293b;border:none;}
.preview-thumb{cursor:pointer;transition:.2s;}
.preview-thumb:hover{transform:scale(1.05);}
#preview-img{max-width:100%;height:auto;max-height:420px;object-fit:contain;border-radius:10px;border:1px solid #334155;}
</style>
</head>
<body class="py-4">
<div class="container" style="max-width:1100px;">
  <h2>💧 Wasserzeichen-Tool von Volker Niederastroth</h2>

  <form method="post" action="save_config.php" enctype="multipart/form-data" class="card p-4 mb-4">

    <!-- Ordnerauswahl -->
    <div class="row g-3 mb-4">
      <div class="col-md-6">
        <label class="form-label">Quellordner (ab DOCUMENT_ROOT)</label>
        <select name="source_dir" class="form-select">
          <?php foreach($dirs as $d): ?>
            <option value="/<?=htmlspecialchars($d)?>" <?=($cfg['source_dir']??'')==='/'.$d?'selected':''?>>/<?=htmlspecialchars($d)?></option>
          <?php endforeach; ?>
          <?php // zusätzlich: relativer Fallback falls vorhanden ?>
          <?php if (!empty($cfg['source_dir']) && !in_array(ltrim($cfg['source_dir'],'/'), $dirs, true)): ?>
            <option value="<?=htmlspecialchars($cfg['source_dir'])?>" selected><?=htmlspecialchars($cfg['source_dir'])?></option>
          <?php endif; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Ausgabeordner (ab DOCUMENT_ROOT oder relativ)</label>
        <select name="output_dir" class="form-select mb-2">
          <?php foreach($dirs as $d): ?>
            <option value="/<?=htmlspecialchars($d)?>" <?=($cfg['output_dir']??'')==='/'.$d?'selected':''?>>/<?=htmlspecialchars($d)?></option>
          <?php endforeach; ?>
          <?php if (!empty($cfg['output_dir']) && !in_array(ltrim($cfg['output_dir'],'/'), $dirs, true)): ?>
            <option value="<?=htmlspecialchars($cfg['output_dir'])?>" selected><?=htmlspecialchars($cfg['output_dir'])?></option>
          <?php endif; ?>
        </select>
        <input type="text" name="new_output_dir" placeholder="📁 Neuen Ordner anlegen (absolut oder relativ)" class="form-control">
      </div>
    </div>

    <!-- Typ + Text -->
    <div class="row g-3 mb-4">
      <div class="col-md-4">
        <label class="form-label">Wasserzeichen-Typ</label>
        <select name="watermark_type" id="wm-type" class="form-select">
          <option value="text" <?=($cfg['watermark_type']??'text')==='text'?'selected':''?>>Text</option>
          <option value="image" <?=($cfg['watermark_type']??'text')==='image'?'selected':''?>>Bild</option>
        </select>
      </div>
      <div class="col-md-8" id="wm-text-wrap">
        <label class="form-label">Wasserzeichen-Text</label>
        <input type="text" name="watermark_text" class="form-control" value="<?=val($cfg,'watermark_text','© Volker')?>">
      </div>
    </div>

    <!-- Schriftart + Größen/Transparenz -->
    <div class="row g-3 mb-4">
      <div class="col-md-6">
        <label class="form-label">Schriftart (aus /assets)</label>
        <select name="font_file" class="form-select">
          <?php foreach($fonts as $f): $v='assets/'.$f; ?>
            <option value="<?=$v?>" <?=($cfg['font_file']??'')===$v?'selected':''?>><?=$f?></option>
          <?php endforeach; ?>
        </select>
		<div class="col-md-4">
  <label class="form-label">Schriftfarbe</label>
  <input type="color" name="color" class="form-control form-control-color"
         value="<?=htmlspecialchars($cfg['color'] ?? '#ffffff', ENT_QUOTES)?>">
</div>

      </div>
      <div class="col-md-2">
        <label class="form-label">Textgröße</label>
        <input type="range" name="font_size" id="font_size" min="10" max="120" value="<?=val($cfg,'font_size',40)?>" class="form-range">
        <small><span id="fontSizeVal"><?=val($cfg,'font_size',40)?></span> px</small>
      </div>
      <div class="col-md-2">
        <label class="form-label">Transparenz</label>
        <input type="range" name="opacity" id="opacity" min="0" max="100" value="<?=val($cfg,'opacity',60)?>" class="form-range">
        <small><span id="opval"><?=val($cfg,'opacity',60)?></span>%</small>
      </div>
      <div class="col-md-2">
        <label class="form-label">Bildgröße</label>
        <input type="range" name="image_scale" id="image_scale" min="1" max="100" value="<?=val($cfg,'image_scale',50)?>" class="form-range">
        <small><span id="imgScaleVal"><?=val($cfg,'image_scale',50)?></span>%</small>
      </div>
    </div>

    <!-- Bild-Wasserzeichen -->
    <div class="row g-3 mb-4" id="wm-image-wrap">
      <div class="col-md-6">
        <label class="form-label">Wasserzeichen-Bild</label>
        <input type="file" name="watermark_image_file" class="form-control" accept=".png,.jpg,.jpeg,.webp,.gif">
      </div>
      <div class="col-md-6">
        <?php
        $wmPath = !empty($cfg['watermark_image']) ? __DIR__ . '/' . $cfg['watermark_image'] : '';
        echo ($wmPath && file_exists($wmPath))
          ? '<img src="'.htmlspecialchars($cfg['watermark_image']).'?t='.time().'" style="max-height:80px;border:1px solid #334155;border-radius:6px;">'
          : '<p class="text-secondary small">Kein Bild-Wasserzeichen vorhanden</p>';
        ?>
      </div>
    </div>

    <!-- Position -->
    <div class="row g-3 mb-4">
      <div class="col-md-4">
        <label class="form-label">Position</label>
        <select name="position" class="form-select">
          <?php
          $posList=['top-left'=>'Oben links','top-right'=>'Oben rechts','bottom-left'=>'Unten links','bottom-right'=>'Unten rechts','center'=>'Zentriert'];
          $sel=$cfg['position']??'bottom-right';
          foreach($posList as $k=>$v){$s=$sel===$k?'selected':'';echo"<option value='$k' $s>$v</option>";}
          ?>
        </select>
      </div>
      <div class="col-md-8 text-end align-self-end">
        <button type="submit" class="btn btn-success me-2">💾 Speichern</button>
        <a href="process.php" class="btn btn-warning">⚙️ Alle verarbeiten</a>
      </div>
    </div>
  </form>

  <!-- Ansicht-Umschalter -->
  <div class="text-center mb-3">
    <button id="toggle-view" class="btn btn-outline-light">🔄 Ansicht: Wasserzeichen</button>
  </div>

  <!-- Live-Vorschau -->
  <div id="preview-wrap" class="text-center mb-4">
    <?php if ($first): ?>
      <img class="preview" id="preview-img" src="preview.php?file=<?=urlencode($first)?>&t=<?=time()?>" alt="<?=htmlspecialchars($first)?>">
    <?php else: ?>
      <div class="text-secondary">Lege zuerst Bilder in <code><?=htmlspecialchars($sourceDir)?></code> ab.</div>
    <?php endif; ?>
  </div>

  <!-- Galerie -->
  <div class="d-flex flex-wrap gap-2 justify-content-start">
    <?php
    $count=0;
    foreach($images as $img){
      $count++;
      $name = safe_name($img);
      echo '<div style="flex:0 0 150px;text-align:center;">';
      echo '<a href="preview.php?file='.urlencode($name).'" class="lightbox-link">';
      echo '<img src="preview.php?file='.urlencode($name).'&t='.time().'" class="preview-thumb" alt="'.htmlspecialchars($name).'" style="width:100%;height:100px;object-fit:cover;border-radius:6px;border:1px solid #334155;">';
      echo '</a><div style="font-size:12px;color:#94a3b8;margin-top:4px;">'.htmlspecialchars($name).'</div></div>';
      if ($count>=48) break;
    }
    if($count===0) echo '<p class="text-secondary">Keine Bilder im Quellordner gefunden.</p>';
    ?>
  </div>
</div>

<!-- Lightbox -->
<div id="lightbox" style="display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.85);justify-content:center;align-items:center;z-index:9999;">
  <img id="lightbox-img" src="" alt="Wasserzeichen-Vorschau" style="max-width:90%;max-height:90%;border-radius:10px;box-shadow:0 0 25px #000;">
</div>

<script>
document.addEventListener('DOMContentLoaded',()=>{
  const type=document.getElementById('wm-type');
  const txt=document.getElementById('wm-text-wrap');
  const img=document.getElementById('wm-image-wrap');
  const op=document.getElementById('opacity');
  const opv=document.getElementById('opval');
  const fsize=document.getElementById('font_size');
  const fval=document.getElementById('fontSizeVal');
  const iscale=document.getElementById('image_scale');
  const ival=document.getElementById('imgScaleVal');
  const toggle=document.getElementById('toggle-view');
  const preview=document.getElementById('preview-img');
  let showWatermark=true;

  function toggleType(){
    if(type.value==='image'){txt.style.display='none';img.style.display='flex';}
    else{txt.style.display='flex';img.style.display='none';}
  }
  if(type){type.addEventListener('change',toggleType);toggleType();}
  if(op)op.addEventListener('input',()=>opv.textContent=op.value);
  if(fsize)fsize.addEventListener('input',()=>fval.textContent=fsize.value);
  if(iscale)iscale.addEventListener('input',()=>ival.textContent=iscale.value);

  // Umschalter Original/Wasserzeichen: Thumbs + große Vorschau
  if(toggle){
    toggle.addEventListener('click',()=>{
      showWatermark=!showWatermark;
      toggle.textContent=showWatermark?'🔄 Ansicht: Wasserzeichen':'🔄 Ansicht: Original';

      document.querySelectorAll('.preview-thumb').forEach(i=>{
        const m=i.src.match(/file=([^&]+)/);
        if(!m) return;
        let url='preview.php?file='+m[1]+'&t='+Date.now();
        if(!showWatermark) url+='&original=1';
        i.src=url;
      });

      if(preview){
        const f=preview.getAttribute('alt') || (preview.src.match(/file=([^&]+)/)?.[1] ?? '');
        if(f){
          let url='preview.php?file='+f+'&t='+Date.now();
          if(!showWatermark) url+='&original=1';
          preview.src=url;
        }
      }
    });
  }

  // Lightbox – WICHTIG: kein Arrow-Function-"this"-Bug
  document.querySelectorAll('.lightbox-link').forEach(function(link){
    link.addEventListener('click', function(e){
      e.preventDefault();
      const lb = document.getElementById('lightbox');
      const img = document.getElementById('lightbox-img');
      const isOriginal = document.getElementById('toggle-view')?.textContent.includes('Original');
      let url = this.getAttribute('href') + '&t=' + Date.now();
      if (isOriginal) url += '&original=1';
      img.src = url;
      lb.style.display = 'flex';
    });
  });
  const lb=document.getElementById('lightbox'), lbImg=document.getElementById('lightbox-img');
  lb.addEventListener('click', e=>{ if(e.target===lb){ lb.style.display='none'; lbImg.src=''; }});
  document.addEventListener('keydown', e=>{ if(e.key==='Escape' && lb.style.display==='flex'){ lb.style.display='none'; lbImg.src=''; }});
});
</script>
</body>
</html>
