<?php
session_start();
require 'functions.php';

// Überprüfe, ob der Benutzer ein Admin ist
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || $_SESSION['role'] !== 'admin') {
    header("location: login.php");
    exit;
}

$message = "";
$error = "";
$user_to_edit = null;
$user_pages_to_edit = [];
$page_to_edit = null;

// JSON-Daten laden
$data = load_data();
$users = $data['users'];
$pages = $data['pages'];
$user_pages = $data['user_pages'];

// Funktion zum Überprüfen, ob ein Benutzername bereits existiert
function username_exists($users, $username, $exclude_id = null) {
    foreach ($users as $user) {
        if ($user['username'] === $username) {
            if ($exclude_id !== null && $user['id'] === $exclude_id) {
                continue;
            }
            return true;
        }
    }
    return false;
}

// Verarbeitung zum Anlegen eines neuen Benutzers
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['create_user'])) {
    $username = trim($_POST['username']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role = 'user'; 

    if (username_exists($users, $username)) {
        $error = "Fehler: Ein Benutzer mit diesem Namen existiert bereits.";
    } else {
        $new_user_id = count($users) > 0 ? max(array_column($users, 'id')) + 1 : 1;
        $new_user = [
            'id' => $new_user_id,
            'username' => $username,
            'password' => $password,
            'role' => $role
        ];
        $users[] = $new_user;
        
        if (isset($_POST['pages']) && is_array($_POST['pages'])) {
            foreach ($_POST['pages'] as $page_id) {
                $user_pages[] = ['user_id' => $new_user_id, 'page_id' => (int)$page_id];
            }
        }
        
        $data['users'] = $users;
        $data['user_pages'] = $user_pages;
        save_data($data);
        $message = "Benutzer erfolgreich erstellt und Seiten zugewiesen.";
    }
}

// Verarbeitung zum Aktualisieren eines Benutzers
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_user'])) {
    $user_id = (int)$_POST['user_id'];
    $username = trim($_POST['username']);
    $role = $_POST['role'];
    $new_password = $_POST['password'];

    if (username_exists($users, $username, $user_id)) {
        $error = "Fehler: Ein Benutzer mit diesem Namen existiert bereits.";
    } else {
        foreach ($users as &$user) {
            if ($user['id'] === $user_id) {
                $user['username'] = $username;
                $user['role'] = $role;
                if (!empty($new_password)) {
                    $user['password'] = password_hash($new_password, PASSWORD_DEFAULT);
                }
                break;
            }
        }
        unset($user);
    
        $user_pages = array_filter($user_pages, function($up) use ($user_id) {
            return $up['user_id'] != $user_id;
        });
    
        if (isset($_POST['pages']) && is_array($_POST['pages'])) {
            foreach ($_POST['pages'] as $page_id) {
                $user_pages[] = ['user_id' => $user_id, 'page_id' => (int)$page_id];
            }
        }
    
        $data['users'] = $users;
        $data['user_pages'] = array_values($user_pages);
        save_data($data);
        $message = "Benutzer erfolgreich aktualisiert.";
    }
}

// Verarbeitung zum Löschen eines Benutzers
if (isset($_GET['delete_user'])) {
    $user_id_to_delete = (int)$_GET['delete_user'];
    
    if ($user_id_to_delete == $_SESSION['id']) {
        $error = "Fehler: Sie können Ihr eigenes Konto nicht löschen.";
    } else {
        $users = array_filter($users, function($user) use ($user_id_to_delete) {
            return $user['id'] !== $user_id_to_delete;
        });
        
        $user_pages = array_filter($user_pages, function($up) use ($user_id_to_delete) {
            return $up['user_id'] !== $user_id_to_delete;
        });
        
        $data['users'] = array_values($users);
        $data['user_pages'] = array_values($user_pages);
        save_data($data);
        $message = "Benutzer erfolgreich gelöscht.";
    }
}

// Verarbeitung zum Hinzufügen einer neuen Seite
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_page'])) {
    $page_name = $_POST['page_name'];
    $file_path = $_POST['file_path'];

    $new_page_id = count($pages) > 0 ? max(array_column($pages, 'id')) + 1 : 1;
    $new_page = [
        'id' => $new_page_id,
        'page_name' => $page_name,
        'file_path' => $file_path
    ];
    $pages[] = $new_page;
    $data['pages'] = $pages;
    save_data($data);
    $message = "Seite erfolgreich zur Datei hinzugefügt.";
}

// Verarbeitung zum Löschen und Bearbeiten von Seiten
if (isset($_GET['delete_page'])) {
    $page_id_to_delete = (int)$_GET['delete_page'];
    
    $pages = array_filter($pages, function($page) use ($page_id_to_delete) {
        return $page['id'] !== $page_id_to_delete;
    });
    $user_pages = array_filter($user_pages, function($up) use ($page_id_to_delete) {
        return $up['page_id'] !== $page_id_to_delete;
    });

    $data['pages'] = array_values($pages);
    $data['user_pages'] = array_values($user_pages);
    save_data($data);
    $message = "Seite erfolgreich gelöscht.";
}

if (isset($_GET['edit_page'])) {
    $edit_page_id = (int)$_GET['edit_page'];
    foreach ($pages as $page) {
        if ($page['id'] === $edit_page_id) {
            $page_to_edit = $page;
            break;
        }
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_page'])) {
    $page_id = (int)$_POST['page_id'];
    $page_name = $_POST['page_name'];
    $file_path = $_POST['file_path'];

    foreach ($pages as &$page) {
        if ($page['id'] === $page_id) {
            $page['page_name'] = $page_name;
            $page['file_path'] = $file_path;
            break;
        }
    }
    unset($page);
    
    $data['pages'] = $pages;
    save_data($data);
    $message = "Seite erfolgreich aktualisiert.";
}

// Benutzer zum Bearbeiten laden
if (isset($_GET['edit_user'])) {
    $edit_user_id = (int)$_GET['edit_user'];
    foreach ($users as $user) {
        if ($user['id'] === $edit_user_id) {
            $user_to_edit = $user;
            break;
        }
    }

    $user_pages_to_edit = array_column(array_filter($user_pages, function($up) use ($edit_user_id) {
        return $up['user_id'] === $edit_user_id;
    }), 'page_id');
}

// Daten erneut laden, um die aktuellen Informationen in den Formularen zu haben
$data = load_data();
$users = $data['users'];
$pages = $data['pages'];
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Admin-Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
</head>
<body>
    <div class="container mt-5">
        <h1 class="mb-4">Admin-Panel</h1>
        
        <?php if (!empty($message)): ?>
            <div class="alert alert-success" role="alert">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $error; ?>
            </div>
        <?php endif; ?>
    
        <?php if ($user_to_edit): ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h3>Benutzer "<?php echo htmlspecialchars($user_to_edit['username']); ?>" bearbeiten</h3>
                </div>
                <div class="card-body">
                    <form action="admin_panel.php" method="post">
                        <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($user_to_edit['id']); ?>">
                        <div class="mb-3">
                            <label for="username" class="form-label">Benutzername:</label>
                            <input type="text" id="username" name="username" class="form-control" value="<?php echo htmlspecialchars($user_to_edit['username']); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="role" class="form-label">Rolle:</label>
                            <select id="role" name="role" class="form-select">
                                <option value="user" <?php if ($user_to_edit['role'] === 'user') echo 'selected'; ?>>User</option>
                                <option value="admin" <?php if ($user_to_edit['role'] === 'admin') echo 'selected'; ?>>Admin</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Neues Passwort (optional):</label>
                            <input type="password" id="password" name="password" class="form-control">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Seiten zuweisen:</label><br>
                            <?php foreach ($pages as $row): ?>
                                <div class="form-check">
                                    <input type="checkbox" name="pages[]" value="<?php echo $row['id']; ?>" id="page-<?php echo $row['id']; ?>" class="form-check-input"
                                           <?php if (in_array($row['id'], $user_pages_to_edit)) echo 'checked'; ?>>
                                    <label class="form-check-label" for="page-<?php echo $row['id']; ?>"><?php echo htmlspecialchars($row['page_name']); ?></label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" name="update_user" class="btn btn-primary">Benutzer aktualisieren</button>
                            <a href="admin_panel.php" class="btn btn-secondary">Bearbeitung abbrechen</a>
                        </div>
                    </form>
                </div>
            </div>
        <?php else: ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h3>Neuen Benutzer anlegen</h3>
                </div>
                <div class="card-body">
                    <form action="admin_panel.php" method="post">
                        <div class="mb-3">
                            <label for="username" class="form-label">Benutzername:</label>
                            <input type="text" id="username" name="username" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Passwort:</label>
                            <input type="password" id="password" name="password" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Seiten zuweisen:</label><br>
                            <?php foreach ($pages as $row): ?>
                                <div class="form-check">
                                    <input type="checkbox" name="pages[]" value="<?php echo $row['id']; ?>" id="create-page-<?php echo $row['id']; ?>" class="form-check-input">
                                    <label class="form-check-label" for="create-page-<?php echo $row['id']; ?>"><?php echo htmlspecialchars($row['page_name']); ?></label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="d-grid">
                            <button type="submit" name="create_user" class="btn btn-success">Benutzer anlegen</button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    
        <hr class="my-5">
    
        <?php if ($page_to_edit): ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h3>Seite "<?php echo htmlspecialchars($page_to_edit['page_name']); ?>" bearbeiten</h3>
                </div>
                <div class="card-body">
                    <form action="admin_panel.php" method="post">
                        <input type="hidden" name="page_id" value="<?php echo htmlspecialchars($page_to_edit['id']); ?>">
                        <div class="mb-3">
                            <label for="page_name" class="form-label">Seitenname:</label>
                            <input type="text" id="page_name" name="page_name" class="form-control" value="<?php echo htmlspecialchars($page_to_edit['page_name']); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="file_path" class="form-label">Dateipfad:</label>
                            <input type="text" id="file_path" name="file_path" class="form-control" value="<?php echo htmlspecialchars($page_to_edit['file_path']); ?>" required>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" name="update_page" class="btn btn-primary">Seite aktualisieren</button>
                            <a href="admin_panel.php" class="btn btn-secondary">Bearbeitung abbrechen</a>
                        </div>
                    </form>
                </div>
            </div>
        <?php else: ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h3>Neue Seite hinzufügen</h3>
                </div>
                <div class="card-body">
                    <form action="admin_panel.php" method="post">
                        <div class="mb-3">
                            <label for="page_name" class="form-label">Seitenname:</label>
                            <input type="text" id="page_name" name="page_name" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="file_path" class="form-label">Dateipfad:</label>
                            <input type="text" id="file_path" name="file_path" class="form-control" required>
                        </div>
                        <div class="d-grid">
                            <button type="submit" name="add_page" class="btn btn-success">Seite hinzufügen</button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    
        <hr class="my-5">
    
        <div class="card mb-4">
            <div class="card-header">
                <h3>Vorhandene Seiten</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Seitenname</th>
                                <th>Dateipfad</th>
                                <th>Aktion</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($pages as $row): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['id'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($row['page_name'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($row['file_path'] ?? ''); ?></td>
                                    <td>
                                        <a href="admin_panel.php?edit_page=<?php echo htmlspecialchars($row['id'] ?? ''); ?>" class="btn btn-sm btn-primary">Bearbeiten</a>
                                        <a href="admin_panel.php?delete_page=<?php echo htmlspecialchars($row['id'] ?? ''); ?>" class="btn btn-sm btn-danger"
                                           onclick="return confirm('Sind Sie sicher, dass Sie diese Seite löschen möchten? Dies kann nicht rückgängig gemacht werden und entfernt die Zuweisungen für alle Benutzer.');">Löschen</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    
        <hr class="my-5">
    
        <div class="card mb-4">
            <div class="card-header">
                <h3>Alle Benutzer verwalten</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Benutzername</th>
                                <th>Rolle</th>
                                <th>Aktion</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $users_for_list = array_filter($users, function($user) {
                                return $user['id'] != $_SESSION['id'];
                            });
                            foreach ($users_for_list as $user): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($user['id'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($user['username'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($user['role'] ?? ''); ?></td>
                                    <td>
                                        <a href="admin_panel.php?edit_user=<?php echo htmlspecialchars($user['id'] ?? ''); ?>" class="btn btn-sm btn-primary">Bearbeiten</a>
                                        <a href="admin_panel.php?delete_user=<?php echo htmlspecialchars($user['id'] ?? ''); ?>" class="btn btn-sm btn-danger"
                                           onclick="return confirm('Sind Sie sicher, dass Sie diesen Benutzer löschen möchten? Dies kann nicht rückgängig gemacht werden.');">Löschen</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    
        <div class="d-flex justify-content-between my-4">
            <a href="dashboard.php" class="btn btn-info">Zurück zum Dashboard</a>
            <a href="logout.php" class="btn btn-warning">Abmelden</a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>