<?php
if (file_exists('config.php')) {
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'];
    $db_name = $_POST['db_name'];
    $db_user = $_POST['db_user'];
    $db_pass = $_POST['db_pass'];
    $admin_user = $_POST['admin_user'];
    $admin_pass = password_hash($_POST['admin_pass'], PASSWORD_DEFAULT);

    try {
        $pdo = new PDO("mysql:host=$db_host", $db_user, $db_pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;");
        $pdo->exec("USE `$db_name`;");

        // Newsletter-Abonnenten Tabelle
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS newsletter_abonnenten (
                id INT AUTO_INCREMENT PRIMARY KEY,
                email VARCHAR(255) NOT NULL UNIQUE,
                eingetragen_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            );
        ");
        
        // Admin-Tabelle
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS newsletter_admin (
                id INT AUTO_INCREMENT PRIMARY KEY,
                benutzername VARCHAR(100) NOT NULL UNIQUE,
                passwort VARCHAR(255) NOT NULL
            );
        ");
        
        // Newsletter-Archiv Tabelle
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS newsletter_archiv (
                id INT AUTO_INCREMENT PRIMARY KEY,
                betreff VARCHAR(255) NOT NULL,
                inhalt TEXT NOT NULL,
                gesendet_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                empfaenger_anzahl INT DEFAULT 0,
                erstellt_von VARCHAR(100) DEFAULT 'Admin'
            );
        ");
        
        // Tabelle für ausstehende Newsletter-Bestätigungen (Double-Opt-In)
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS newsletter_pending (
                id INT AUTO_INCREMENT PRIMARY KEY,
                email VARCHAR(255) NOT NULL UNIQUE,
                token VARCHAR(64) NOT NULL UNIQUE,
                erstellt_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            );
        ");
        
        // Indices für bessere Performance
        $pdo->exec("CREATE INDEX IF NOT EXISTS idx_gesendet_am ON newsletter_archiv(gesendet_am DESC);");
        $pdo->exec("CREATE INDEX IF NOT EXISTS idx_token ON newsletter_pending(token);");
        $pdo->exec("CREATE INDEX IF NOT EXISTS idx_erstellt_am ON newsletter_pending(erstellt_am);");
        
        // Admin-User erstellen
        $stmt = $pdo->prepare("INSERT IGNORE INTO newsletter_admin (benutzername, passwort) VALUES (?, ?)");
        $stmt->execute([$admin_user, $admin_pass]);

        // Config-Datei erstellen
        $config = "<?php\nreturn [\n'db_host'=>'$db_host','db_name'=>'$db_name','db_user'=>'$db_user','db_pass'=>'$db_pass'\n];\n?>";
        file_put_contents("config.php", $config);

        echo '<div class="alert alert-success mt-4">
                <h4>Installation erfolgreich abgeschlossen!</h4>
                <p>Folgende Tabellen wurden erstellt:</p>
                <ul>
                    <li>newsletter_abonnenten - Für die E-Mail-Adressen</li>
                    <li>newsletter_admin - Für die Admin-Zugänge</li>
                    <li>newsletter_archiv - Für gesendete Newsletter</li>
                    <li>newsletter_pending - Für Double-Opt-In Bestätigungen</li>
                </ul>
                <p><strong>Das System ist jetzt vollständig installiert und einsatzbereit!</strong></p>
                <a href="login.php" class="btn btn-primary mt-2">Zum Login</a>
              </div>';
    } catch (PDOException $e) {
        echo '<div class="alert alert-danger mt-4">Fehler bei der Installation: '.$e->getMessage().'</div>';
    }
}
?>

<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Newsletter Installation</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0"><i class="fas fa-cog me-2"></i>Newsletter System Installation</h3>
                </div>
                <div class="card-body">
                    <p class="text-muted mb-4">
                        Willkommen zur Installation des Newsletter-Systems. Bitte füllen Sie alle Felder aus, 
                        um die Datenbank und den Admin-Zugang einzurichten.
                    </p>
                    
                    <form method="POST" class="mt-3">
                        <h5 class="mb-3"><i class="fas fa-database me-2"></i>Datenbank-Konfiguration</h5>
                        
                        <div class="mb-3">
                            <label class="form-label">Datenbank-Host</label>
                            <input type="text" name="db_host" class="form-control" value="localhost" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Datenbank-Name</label>
                            <input type="text" name="db_name" class="form-control" placeholder="z.B. newsletter_db" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Datenbank-Benutzer</label>
                            <input type="text" name="db_user" class="form-control" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Datenbank-Passwort</label>
                            <input type="password" name="db_pass" class="form-control">
                        </div>
                        
                        <hr class="my-4">
                        
                        <h5 class="mb-3"><i class="fas fa-user-shield me-2"></i>Admin-Zugang</h5>
                        
                        <div class="mb-3">
                            <label class="form-label">Admin-Benutzername</label>
                            <input type="text" name="admin_user" class="form-control" placeholder="z.B. admin" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Admin-Passwort</label>
                            <input type="password" name="admin_pass" class="form-control" minlength="6" required>
                            <div class="form-text">Mindestens 6 Zeichen</div>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Was wird installiert?</strong><br>
                            Das System erstellt automatisch alle benötigten Tabellen:
                            <ul class="mb-0 mt-2">
                                <li>Abonnenten-Verwaltung</li>
                                <li>Admin-Bereich</li>
                                <li>Newsletter-Archiv</li>
                            </ul>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-play me-2"></i>Installation starten
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>