<?php
session_start();
require_once '../config.php';

if (!isset($_SESSION["connecte"])) {
    header("Location: index.php");
    exit;
}

$uploadDir = __DIR__ . '/../uploads/';

// 1. Alle Bildnamen aus der Datenbank holen
$stmt = $conn->query("SELECT bild FROM news WHERE bild <> ''");
$dbImages = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);

// 2. Alle Dateien im uploads-Ordner auflisten
$files = scandir($uploadDir);

// 3. Nicht genutzte Bilder löschen
$deletedFiles = [];

foreach ($files as $file) {
    if ($file === '.' || $file === '..') continue;

    $filePath = $uploadDir . $file;

    if (is_file($filePath)) {
        if (!in_array($file, $dbImages)) {
            if (unlink($filePath)) {
                $deletedFiles[] = $file;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Aufräumen abgeschlossen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <div class="card shadow-sm">
        <div class="card-body">
            <h2 class="card-title mb-4">Aufräumen abgeschlossen</h2>
            <?php if (count($deletedFiles) > 0): ?>
                <p>Folgende ungenutzte Bilder wurden gelöscht:</p>
                <ul class="list-group mb-3">
                    <?php foreach ($deletedFiles as $deleted): ?>
                        <li class="list-group-item"><?= htmlspecialchars($deleted) ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="mb-3">Keine ungenutzten Bilder gefunden.</p>
            <?php endif; ?>

            <a href="dashboard.php" class="btn btn-primary">Zurück zum Dashboard</a>
        </div>
    </div>
</div>
</body>
</html>
